/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.interceptor.business;

import com.anwen.mongo.cache.global.CollectionLogicDeleteCache;
import com.anwen.mongo.interceptor.Interceptor;
import com.anwen.mongo.logic.LogicDeleteHandler;
import com.anwen.mongo.model.LogicDeleteResult;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.InsertOneModel;
import com.mongodb.client.model.WriteModel;
import java.util.List;
import java.util.Objects;
import org.bson.Document;

public class LogicAutoFillInterceptor
implements Interceptor {
    @Override
    public List<Document> executeSave(List<Document> documentList, MongoCollection<Document> collection) {
        if (CollectionLogicDeleteCache.getLogicIgnore()) {
            return documentList;
        }
        Class<?> clazz = LogicDeleteHandler.getBeanClass(collection);
        if (Objects.isNull(clazz)) {
            return documentList;
        }
        LogicDeleteResult result = LogicDeleteHandler.mapper().get(clazz);
        if (Objects.nonNull(result)) {
            for (Document document : documentList) {
                if (document.containsKey((Object)result.getColumn())) continue;
                document.put(result.getColumn(), (Object)result.getLogicNotDeleteValue());
            }
        }
        return documentList;
    }

    @Override
    public List<WriteModel<Document>> executeBulkWrite(List<WriteModel<Document>> writeModelList, MongoCollection<Document> collection) {
        if (CollectionLogicDeleteCache.getLogicIgnore()) {
            return writeModelList;
        }
        Class<?> clazz = LogicDeleteHandler.getBeanClass(collection);
        if (Objects.isNull(clazz)) {
            return writeModelList;
        }
        for (WriteModel<Document> documentWriteModel : writeModelList) {
            if (!(documentWriteModel instanceof InsertOneModel)) continue;
            Document document = (Document)((InsertOneModel)documentWriteModel).getDocument();
            LogicDeleteResult result = LogicDeleteHandler.mapper().get(clazz);
            if (!Objects.nonNull(result) || document.containsKey((Object)result.getColumn())) continue;
            document.put(result.getColumn(), (Object)result.getLogicNotDeleteValue());
        }
        return writeModelList;
    }
}

