/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.interceptor.business;

import com.anwen.mongo.enums.ExecuteMethodEnum;
import com.anwen.mongo.handlers.CollectionNameHandler;
import com.anwen.mongo.interceptor.Interceptor;
import com.anwen.mongo.manager.MongoPlusClient;
import com.mongodb.MongoNamespace;
import com.mongodb.client.MongoCollection;
import org.bson.Document;

public class DynamicCollectionNameInterceptor
implements Interceptor {
    private final CollectionNameHandler collectionNameHandler;
    private final MongoPlusClient mongoPlusClient;

    public DynamicCollectionNameInterceptor(CollectionNameHandler collectionNameHandler, MongoPlusClient mongoPlusClient) {
        this.collectionNameHandler = collectionNameHandler;
        this.mongoPlusClient = mongoPlusClient;
    }

    @Override
    public int order() {
        return 2;
    }

    @Override
    public void beforeExecute(ExecuteMethodEnum executeMethodEnum, Object[] source, MongoCollection<Document> collection) {
        MongoNamespace namespace = collection.getNamespace();
        String collectionName = this.collectionNameHandler.dynamicCollectionName(executeMethodEnum, source, namespace);
        source[source.length - 1] = this.mongoPlusClient.getCollection(namespace.getDatabaseName(), collectionName);
    }
}

