/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.interceptor.business;

import com.anwen.mongo.cache.codec.MapCodecCache;
import com.anwen.mongo.cache.global.DataSourceNameCache;
import com.anwen.mongo.domain.MongoPlusException;
import com.anwen.mongo.enums.ExecuteMethodEnum;
import com.anwen.mongo.enums.SpecialConditionEnum;
import com.anwen.mongo.interceptor.Interceptor;
import com.anwen.mongo.logging.Log;
import com.anwen.mongo.logging.LogFactory;
import com.anwen.mongo.mapper.BaseMapper;
import com.anwen.mongo.model.OperationResult;
import com.anwen.mongo.toolkit.StringUtils;
import com.mongodb.MongoNamespace;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.InsertOneModel;
import com.mongodb.client.model.UpdateManyModel;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.Document;
import org.bson.conversions.Bson;

public class DataChangeRecorderInnerInterceptor
implements Interceptor {
    private final Log log = LogFactory.getLog(DataChangeRecorderInnerInterceptor.class);
    private String exceptionMessage = "The operation has exceeded the security threshold and has been intercepted!";
    private List<String> ignoredColumnList = new CopyOnWriteArrayList<String>(){
        {
            this.add("DATA_CHANGE_RECORD");
        }
    };
    private Integer batchUpdateLimit = 1000;
    private Boolean displayCompleteData = true;
    private Boolean enableSaveDatabase = false;
    private BaseMapper baseMapper;
    private String datasourceName;
    private Boolean isMasterDatasource = false;
    private String databaseName;
    private String collectionName = "DATA_CHANGE_RECORD";
    private static final ThreadLocal<OperationResult> operationResultThreadLocal = ThreadLocal.withInitial(() -> null);

    @Override
    public void beforeExecute(ExecuteMethodEnum executeMethodEnum, Object[] source, MongoCollection<Document> collection) {
        if (this.shouldIgnoreCollection(collection)) {
            return;
        }
        long startTs = System.currentTimeMillis();
        OperationResult operationResult = this.processOperation(executeMethodEnum, source);
        if (operationResult != null) {
            MongoNamespace namespace = collection.getNamespace();
            operationResult.setDatasourceName(DataSourceNameCache.getDataSource());
            operationResult.setDatabaseName(namespace.getDatabaseName());
            operationResult.setCollectionName(namespace.getCollectionName());
            operationResult.setRecordStatus(true);
            long costThis = System.currentTimeMillis() - startTs;
            operationResult.setCost(costThis);
            this.log.info(String.format("%s DataChangeRecord: %s", executeMethodEnum.name(), operationResult));
            if (this.enableSaveDatabase.booleanValue()) {
                operationResultThreadLocal.set(operationResult);
            }
        }
    }

    @Override
    public void afterExecute(ExecuteMethodEnum executeMethodEnum, Object[] source, Object result, MongoCollection<Document> collection) {
        if (this.shouldIgnoreCollection(collection) || !this.isRelevantMethod(executeMethodEnum)) {
            return;
        }
        if (this.enableSaveDatabase.booleanValue()) {
            String datasource = this.determineDatasource();
            DataSourceNameCache.setDataSource(datasource);
            String databaseName = this.determineDatabaseName();
            this.baseMapper.save(databaseName, this.collectionName, operationResultThreadLocal.get());
            operationResultThreadLocal.remove();
        }
    }

    private boolean shouldIgnoreCollection(MongoCollection<Document> collection) {
        return this.ignoredColumnList.contains(collection.getNamespace().getCollectionName());
    }

    private boolean isRelevantMethod(ExecuteMethodEnum executeMethodEnum) {
        return executeMethodEnum == ExecuteMethodEnum.SAVE || executeMethodEnum == ExecuteMethodEnum.UPDATE || executeMethodEnum == ExecuteMethodEnum.REMOVE || executeMethodEnum == ExecuteMethodEnum.BULK_WRITE;
    }

    private String determineDatasource() {
        if (StringUtils.isNotBlank(this.datasourceName)) {
            return this.datasourceName;
        }
        if (this.isMasterDatasource.booleanValue()) {
            return "master";
        }
        return DataSourceNameCache.getDataSource();
    }

    private String determineDatabaseName() {
        return StringUtils.isNotBlank(this.databaseName) ? this.databaseName : DataSourceNameCache.getDatabase();
    }

    private OperationResult processOperation(ExecuteMethodEnum executeMethodEnum, Object[] source) throws DataUpdateLimitationException {
        switch (executeMethodEnum) {
            case SAVE: {
                return this.processSave(source);
            }
            case UPDATE: {
                return this.processUpdate(source);
            }
            case REMOVE: {
                return this.processRemove(source);
            }
            case BULK_WRITE: {
                return this.processBulkWrite(source);
            }
        }
        return null;
    }

    private OperationResult processSave(Object[] source) throws DataUpdateLimitationException {
        List documentList = this.castList(source[0]);
        if (documentList.size() > this.batchUpdateLimit) {
            this.log.error("batch save limit exceed: count={}, BATCH_UPDATE_LIMIT={}", documentList.size(), this.batchUpdateLimit);
            throw new DataUpdateLimitationException(this.exceptionMessage);
        }
        OperationResult operationResult = new OperationResult();
        operationResult.setOperation(ExecuteMethodEnum.SAVE.name());
        operationResult.setChangedData(this.displayCompleteData != false ? documentList.toString() : String.valueOf(documentList.size()));
        return operationResult;
    }

    private OperationResult processUpdate(Object[] source) throws DataUpdateLimitationException {
        List documentList = this.castList(source[0]);
        if (documentList.size() > this.batchUpdateLimit) {
            this.log.error("batch update limit exceed: count={}, BATCH_UPDATE_LIMIT={}", documentList.size(), this.batchUpdateLimit);
            throw new DataUpdateLimitationException(this.exceptionMessage);
        }
        OperationResult operationResult = new OperationResult();
        operationResult.setOperation(ExecuteMethodEnum.UPDATE.name());
        List dataList = documentList.stream().map(mutablePair -> {
            String left = ((Bson)mutablePair.getRight()).toBsonDocument(BsonDocument.class, MapCodecCache.getDefaultCodecRegistry()).toString();
            String right = ((Bson)mutablePair.getRight()).toBsonDocument(BsonDocument.class, MapCodecCache.getDefaultCodecRegistry()).toString();
            return "(left=" + left + ",right=" + right + ")";
        }).collect(Collectors.toList());
        operationResult.setChangedData(this.displayCompleteData != false ? dataList.toString() : String.valueOf(documentList.size()));
        return operationResult;
    }

    private OperationResult processRemove(Object[] source) throws DataUpdateLimitationException {
        Bson bson = (Bson)source[0];
        BsonDocument bsonDocument = bson.toBsonDocument(BsonDocument.class, MapCodecCache.getDefaultCodecRegistry());
        bsonDocument.forEach((k, v) -> {
            BsonArray inArray;
            if (v.isDocument() && v.asDocument().containsKey((Object)SpecialConditionEnum.IN.getCondition()) && (inArray = v.asDocument().get((Object)SpecialConditionEnum.IN.getCondition()).asArray()).size() > this.batchUpdateLimit) {
                this.log.error("batch remove limit exceed: count={}, BATCH_UPDATE_LIMIT={}", inArray.size(), this.batchUpdateLimit);
                throw new DataUpdateLimitationException(this.exceptionMessage);
            }
        });
        OperationResult operationResult = new OperationResult();
        operationResult.setOperation(ExecuteMethodEnum.REMOVE.name());
        operationResult.setChangedData(this.displayCompleteData != false ? bsonDocument.toString() : String.valueOf(bsonDocument.size()));
        return operationResult;
    }

    private OperationResult processBulkWrite(Object[] source) {
        List writeModelList = this.castList(source[0]);
        long insertCount = writeModelList.stream().filter(writeModel -> writeModel instanceof InsertOneModel).count();
        long updateCount = writeModelList.stream().filter(writeModel -> writeModel instanceof UpdateManyModel).count();
        if (insertCount > (long)this.batchUpdateLimit.intValue() || updateCount > (long)this.batchUpdateLimit.intValue()) {
            this.log.error("batch bulkWrite limit exceed: count={}, BATCH_UPDATE_LIMIT={}", insertCount, this.batchUpdateLimit);
            throw new DataUpdateLimitationException(this.exceptionMessage);
        }
        OperationResult operationResult = new OperationResult();
        operationResult.setOperation(ExecuteMethodEnum.BULK_WRITE.name());
        if (this.displayCompleteData.booleanValue()) {
            List dataList = writeModelList.stream().map(writeModel -> {
                if (writeModel instanceof InsertOneModel) {
                    return writeModel.toString();
                }
                if (writeModel instanceof UpdateManyModel) {
                    UpdateManyModel updateManyModel = (UpdateManyModel)writeModel;
                    return "UpdateManyModel{filter=" + updateManyModel.getFilter() + ", update=" + (updateManyModel.getUpdate() != null ? updateManyModel.getUpdate().toBsonDocument(BsonDocument.class, MapCodecCache.getDefaultCodecRegistry()).toString() : updateManyModel.getUpdatePipeline()) + ", options=" + updateManyModel.getUpdatePipeline() + '}';
                }
                return "";
            }).collect(Collectors.toList());
            operationResult.setChangedData(dataList.toString());
        } else {
            operationResult.setChangedData(String.valueOf(writeModelList.size()));
        }
        return operationResult;
    }

    private <T> List<T> castList(Object obj) {
        return (List)obj;
    }

    public String getDatasourceName() {
        return this.datasourceName;
    }

    public void setDatasourceName(String datasourceName) {
        this.datasourceName = datasourceName;
    }

    public Boolean getIsMasterDatasource() {
        return this.isMasterDatasource;
    }

    public void isMasterDatasource(Boolean masterDatasource) {
        this.isMasterDatasource = masterDatasource;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public void setCollectionName(String collectionName) {
        this.ignoredColumnList.add(collectionName);
        this.collectionName = collectionName;
    }

    public void enableSaveDatabase(BaseMapper baseMapper) {
        this.enableSaveDatabase = true;
        this.baseMapper = baseMapper;
    }

    public BaseMapper getBaseMapper() {
        return this.baseMapper;
    }

    public Boolean getDisplayCompleteData() {
        return this.displayCompleteData;
    }

    public void setDisplayCompleteData(Boolean displayCompleteData) {
        this.displayCompleteData = displayCompleteData;
    }

    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    public void setExceptionMessage(String exceptionMessage) {
        this.exceptionMessage = exceptionMessage;
    }

    public List<String> getIgnoredColumnList() {
        return this.ignoredColumnList;
    }

    public void setIgnoredColumnList(List<String> ignoredColumnList) {
        this.ignoredColumnList = ignoredColumnList;
    }

    public Integer getBatchUpdateLimit() {
        return this.batchUpdateLimit;
    }

    public void setBatchUpdateLimit(Integer batchUpdateLimit) {
        this.batchUpdateLimit = batchUpdateLimit;
    }

    public static class DataUpdateLimitationException
    extends MongoPlusException {
        public DataUpdateLimitationException(String message) {
            super(message);
        }
    }
}

