/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.interceptor.business;

import com.anwen.mongo.cache.global.CollectionLogicDeleteCache;
import com.anwen.mongo.interceptor.Interceptor;
import com.anwen.mongo.logic.LogicDeleteHandler;
import com.anwen.mongo.model.MutablePair;
import com.anwen.mongo.model.QueryParam;
import com.mongodb.BasicDBObject;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.CountOptions;
import com.mongodb.client.model.UpdateManyModel;
import com.mongodb.client.model.WriteModel;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bson.Document;
import org.bson.conversions.Bson;

public class CollectionLogiceInterceptor
implements Interceptor {
    @Override
    public Bson executeRemove(Bson filter, MongoCollection<Document> collection) {
        if (CollectionLogicDeleteCache.getLogicIgnore()) {
            return filter;
        }
        Class<?> clazz = LogicDeleteHandler.getBeanClass(collection);
        if (LogicDeleteHandler.close() || Objects.isNull(clazz)) {
            return filter;
        }
        return LogicDeleteHandler.doBsonLogicDel(filter, clazz);
    }

    @Override
    public QueryParam executeQuery(Bson queryBasic, BasicDBObject projectionList, BasicDBObject sortCond, MongoCollection<Document> collection) {
        if (CollectionLogicDeleteCache.getLogicIgnore()) {
            return new QueryParam(queryBasic, projectionList, sortCond);
        }
        Class<?> clazz = LogicDeleteHandler.getBeanClass(collection);
        if (LogicDeleteHandler.close() || Objects.isNull(clazz)) {
            return new QueryParam(queryBasic, projectionList, sortCond);
        }
        Bson query = LogicDeleteHandler.doBsonLogicDel(queryBasic, clazz);
        return new QueryParam(query, projectionList, sortCond);
    }

    @Override
    public MutablePair<BasicDBObject, CountOptions> executeCount(BasicDBObject queryBasic, CountOptions countOptions, MongoCollection<Document> collection) {
        if (CollectionLogicDeleteCache.getLogicIgnore()) {
            return new MutablePair<BasicDBObject, CountOptions>(queryBasic, countOptions);
        }
        Class<?> clazz = LogicDeleteHandler.getBeanClass(collection);
        if (LogicDeleteHandler.close() || Objects.isNull(clazz)) {
            return new MutablePair<BasicDBObject, CountOptions>(queryBasic, countOptions);
        }
        BasicDBObject query = (BasicDBObject)LogicDeleteHandler.doBsonLogicDel((Bson)queryBasic, clazz);
        return new MutablePair<BasicDBObject, CountOptions>(query, countOptions);
    }

    @Override
    public List<WriteModel<Document>> executeBulkWrite(List<WriteModel<Document>> writeModelList, MongoCollection<Document> collection) {
        if (CollectionLogicDeleteCache.getLogicIgnore()) {
            return writeModelList;
        }
        Class<?> clazz = LogicDeleteHandler.getBeanClass(collection);
        if (LogicDeleteHandler.close() || Objects.isNull(clazz)) {
            return writeModelList;
        }
        return writeModelList.stream().map(item -> {
            if (item instanceof UpdateManyModel) {
                UpdateManyModel umm = (UpdateManyModel)item;
                Bson filter = LogicDeleteHandler.doBsonLogicDel(umm.getFilter(), clazz);
                return new UpdateManyModel(filter, umm.getUpdate());
            }
            return item;
        }).collect(Collectors.toList());
    }
}

