/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.interceptor;

import com.anwen.mongo.enums.ExecuteMethodEnum;
import com.anwen.mongo.model.MutablePair;
import com.anwen.mongo.model.QueryParam;
import com.mongodb.BasicDBObject;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.CountOptions;
import com.mongodb.client.model.WriteModel;
import java.util.List;
import org.bson.Document;
import org.bson.conversions.Bson;

public interface Interceptor {
    default public int order() {
        return Integer.MAX_VALUE;
    }

    default public void beforeExecute(ExecuteMethodEnum executeMethodEnum, Object[] source, MongoCollection<Document> collection) {
    }

    default public void afterExecute(ExecuteMethodEnum executeMethodEnum, Object[] source, Object result, MongoCollection<Document> collection) {
    }

    default public List<Document> executeSave(List<Document> documentList) {
        return documentList;
    }

    default public Bson executeRemove(Bson filter) {
        return filter;
    }

    default public List<MutablePair<Bson, Bson>> executeUpdate(List<MutablePair<Bson, Bson>> updatePairList) {
        return updatePairList;
    }

    default public QueryParam executeQuery(Bson queryBasic, BasicDBObject projectionList, BasicDBObject sortCond) {
        return new QueryParam(queryBasic, projectionList, sortCond);
    }

    default public List<Bson> executeAggregates(List<Bson> aggregateConditionList) {
        return aggregateConditionList;
    }

    default public MutablePair<BasicDBObject, CountOptions> executeCount(BasicDBObject queryBasic, CountOptions countOptions) {
        return new MutablePair<BasicDBObject, CountOptions>(queryBasic, countOptions);
    }

    default public List<WriteModel<Document>> executeBulkWrite(List<WriteModel<Document>> writeModelList) {
        return writeModelList;
    }

    default public List<Document> executeSave(List<Document> documentList, MongoCollection<Document> collection) {
        return documentList;
    }

    default public Bson executeRemove(Bson filter, MongoCollection<Document> collection) {
        return filter;
    }

    default public List<MutablePair<Bson, Bson>> executeUpdate(List<MutablePair<Bson, Bson>> updatePairList, MongoCollection<Document> collection) {
        return updatePairList;
    }

    default public QueryParam executeQuery(Bson queryBasic, BasicDBObject projectionList, BasicDBObject sortCond, MongoCollection<Document> collection) {
        return new QueryParam(queryBasic, projectionList, sortCond);
    }

    default public List<Bson> executeAggregates(List<Bson> aggregateConditionList, MongoCollection<Document> collection) {
        return aggregateConditionList;
    }

    default public MutablePair<BasicDBObject, CountOptions> executeCount(BasicDBObject queryBasic, CountOptions countOptions, MongoCollection<Document> collection) {
        return new MutablePair<BasicDBObject, CountOptions>(queryBasic, countOptions);
    }

    default public List<WriteModel<Document>> executeBulkWrite(List<WriteModel<Document>> writeModelList, MongoCollection<Document> collection) {
        return writeModelList;
    }
}

