/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.handlers.condition;

import com.anwen.mongo.annotation.comm.FieldEncrypt;
import com.anwen.mongo.conditions.interfaces.condition.CompareCondition;
import com.anwen.mongo.handlers.condition.ConditionHandler;
import com.anwen.mongo.toolkit.EncryptorUtil;
import com.mongodb.BasicDBObject;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class EncryptorConditionHandler
implements ConditionHandler {
    public final Map<Field, FieldEncrypt> fieldFieldEncryptMap = new ConcurrentHashMap<Field, FieldEncrypt>();
    public final Map<Field, Boolean> fieldEncryptPresent = new ConcurrentHashMap<Field, Boolean>();

    @Override
    public void beforeQueryCondition(CompareCondition compareCondition, BasicDBObject basicDBObject) {
        Field originalField = compareCondition.getOriginalField();
        if (originalField != null) {
            Boolean existFieldEncrypt = this.fieldEncryptPresent.computeIfAbsent(originalField, field -> field.isAnnotationPresent(FieldEncrypt.class));
            if (!existFieldEncrypt.booleanValue()) {
                return;
            }
            FieldEncrypt fieldEncrypt = this.fieldFieldEncryptMap.computeIfAbsent(originalField, field -> field.getAnnotation(FieldEncrypt.class));
            compareCondition.setValue(EncryptorUtil.encrypt(fieldEncrypt, compareCondition.getValue()));
        }
    }
}

