/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.handlers.condition;

import com.anwen.mongo.bson.MongoPlusBasicDBObject;
import com.anwen.mongo.cache.global.HandlerCache;
import com.anwen.mongo.conditions.interfaces.condition.CompareCondition;
import com.anwen.mongo.conditions.update.UpdateChainWrapper;
import com.anwen.mongo.enums.QueryOperatorEnum;
import com.anwen.mongo.enums.UpdateConditionEnum;
import com.anwen.mongo.handlers.condition.Condition;
import com.anwen.mongo.handlers.condition.UpdateCondition;
import com.anwen.mongo.model.BuildUpdate;
import com.anwen.mongo.model.MutablePair;
import com.anwen.mongo.toolkit.CollUtil;
import com.mongodb.BasicDBObject;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;

public abstract class AbstractCondition
implements Condition,
UpdateCondition {
    @Override
    public BasicDBObject queryCondition(List<CompareCondition> compareConditionList) {
        MongoPlusBasicDBObject mongoPlusBasicDBObject = new MongoPlusBasicDBObject();
        if (CollUtil.isNotEmpty(compareConditionList)) {
            compareConditionList.stream().filter(compareCondition -> QueryOperatorEnum.isQueryOperator((String)compareCondition.getCondition())).forEach(compareCondition -> this.queryCondition((CompareCondition)compareCondition, mongoPlusBasicDBObject));
        }
        return mongoPlusBasicDBObject;
    }

    @Override
    public BasicDBObject queryCondition(CompareCondition compareCondition) {
        return this.queryCondition(compareCondition, new MongoPlusBasicDBObject());
    }

    @Override
    public MutablePair<BasicDBObject, BasicDBObject> updateCondition(UpdateChainWrapper<?, ?> updateChainWrapper) {
        List<CompareCondition> updateCompareList = updateChainWrapper.getUpdateCompareList();
        BasicDBObject queryBasic = this.queryCondition(updateChainWrapper.getCompareList());
        Map conditionMap = Arrays.stream(UpdateConditionEnum.values()).collect(Collectors.toMap(Function.identity(), conditionEnum -> updateCompareList.stream().filter(compareCondition -> Objects.equals(compareCondition.getCondition(), conditionEnum.getSubCondition())).collect(Collectors.toList())));
        BasicDBObject updateBasicDBObject = new BasicDBObject();
        conditionMap.forEach((conditionEnum, compareConditionList) -> {
            if (CollUtil.isNotEmpty(compareConditionList)) {
                updateBasicDBObject.append(conditionEnum.getCondition(), (Object)this.updateValue((UpdateConditionEnum)conditionEnum, (List<CompareCondition>)compareConditionList));
            }
        });
        return new MutablePair<BasicDBObject, BasicDBObject>(queryBasic, updateBasicDBObject);
    }

    public BasicDBObject updateValue(UpdateConditionEnum updateConditionEnum, List<CompareCondition> compareConditionList) {
        AtomicReference<List<CompareCondition>> finalCompareConditionList = new AtomicReference<List<CompareCondition>>(compareConditionList);
        BiFunction<AbstractCondition, BuildUpdate, BasicDBObject> updateValueFunc = (condition, buildUpdate) -> {
            List currentCompareConditionList = (List)finalCompareConditionList.get();
            switch (updateConditionEnum) {
                case SET: 
                case INC: 
                case MIN: 
                case MAX: 
                case MUL: 
                case POP: {
                    return condition.buildUpdateCondition(currentCompareConditionList, (BuildUpdate)buildUpdate);
                }
                case PUSH: {
                    finalCompareConditionList.set(currentCompareConditionList.stream().distinct().collect(Collectors.toList()));
                    currentCompareConditionList = (List)finalCompareConditionList.get();
                    return condition.buildPushCondition(currentCompareConditionList, (BuildUpdate)buildUpdate);
                }
                case CURRENT_DATE: {
                    return condition.buildCurrentDateCondition(currentCompareConditionList, (BuildUpdate)buildUpdate);
                }
                case RENAME: {
                    return condition.buildRenameCondition(currentCompareConditionList, (BuildUpdate)buildUpdate);
                }
                case UNSET: {
                    return condition.buildUnsetCondition(currentCompareConditionList, (BuildUpdate)buildUpdate);
                }
                case ADD_TO_SET: {
                    return condition.buildAddToSetCondition(currentCompareConditionList, (BuildUpdate)buildUpdate);
                }
            }
            return null;
        };
        BasicDBObject updateBasicDBObject = new BasicDBObject();
        finalCompareConditionList.get().forEach(compareCondition -> {
            HandlerCache.conditionHandlerList.forEach(conditionHandler -> conditionHandler.beforeUpdateCondition((CompareCondition)compareCondition, updateBasicDBObject));
            updateValueFunc.apply(this, new BuildUpdate((CompareCondition)compareCondition, updateBasicDBObject));
            HandlerCache.conditionHandlerList.forEach(conditionHandler -> conditionHandler.afterUpdateCondition((CompareCondition)compareCondition, updateBasicDBObject));
        });
        return updateBasicDBObject;
    }

    public abstract BasicDBObject queryCondition(CompareCondition var1, MongoPlusBasicDBObject var2);
}

