/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.factory;

import com.anwen.mongo.cache.global.DataSourceNameCache;
import com.anwen.mongo.logging.Log;
import com.anwen.mongo.logging.LogFactory;
import com.mongodb.client.MongoClient;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MongoClientFactory
implements AutoCloseable {
    private final Log log = LogFactory.getLog(MongoClientFactory.class);
    private final Map<String, MongoClient> mongoClientMap = new ConcurrentHashMap<String, MongoClient>();
    private static MongoClientFactory mongoClientFactory;

    private MongoClientFactory() {
    }

    private MongoClientFactory(MongoClient mongoClient) {
        new MongoClientFactory("master", mongoClient);
    }

    private MongoClientFactory(String ds, MongoClient mongoClient) {
        this.mongoClientMap.put(ds, mongoClient);
    }

    public static MongoClientFactory getInstance(String ds, MongoClient mongoClient) {
        if (mongoClientFactory == null) {
            mongoClientFactory = new MongoClientFactory();
        }
        mongoClientFactory.addMongoClient(ds, mongoClient);
        return mongoClientFactory;
    }

    public static MongoClientFactory getInstance(MongoClient mongoClient) {
        return MongoClientFactory.getInstance("master", mongoClient);
    }

    public static MongoClientFactory getInstance(Map<String, MongoClient> mongoClientMap) {
        mongoClientFactory = new MongoClientFactory();
        MongoClientFactory.mongoClientFactory.mongoClientMap.putAll(mongoClientMap);
        return mongoClientFactory;
    }

    public static MongoClientFactory getInstance() {
        return mongoClientFactory;
    }

    public void addMongoClient(String ds, MongoClient mongoClient) {
        this.mongoClientMap.put(ds, mongoClient);
    }

    public MongoClient getMongoClient(String ds) {
        return this.mongoClientMap.get(ds);
    }

    public Boolean containsMongoClient(String ds) {
        return this.mongoClientMap.containsKey(ds);
    }

    public MongoClient getMongoClient() {
        return this.getMongoClient(DataSourceNameCache.getDataSource());
    }

    public Map<String, MongoClient> getMongoClientMap() {
        return this.mongoClientMap;
    }

    @Override
    public void close() throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Destroy data source connection client");
        }
        this.mongoClientMap.forEach((ds, mongoClient) -> mongoClient.close());
    }
}

