/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.execute.instance;

import com.anwen.mongo.convert.DocumentMapperConvert;
import com.anwen.mongo.execute.Execute;
import com.anwen.mongo.model.MutablePair;
import com.mongodb.BasicDBObject;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.AggregateIterable;
import com.mongodb.client.ClientSession;
import com.mongodb.client.FindIterable;
import com.mongodb.client.ListIndexesIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.CountOptions;
import com.mongodb.client.model.CreateIndexOptions;
import com.mongodb.client.model.DropIndexOptions;
import com.mongodb.client.model.IndexModel;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.WriteModel;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.InsertManyResult;
import com.mongodb.client.result.UpdateResult;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.conversions.Bson;

public class SessionExecute
implements Execute {
    private final ClientSession clientSession;

    public SessionExecute(ClientSession clientSession) {
        this.clientSession = clientSession;
    }

    @Override
    public InsertManyResult executeSave(List<Document> documentList, MongoCollection<Document> collection) {
        return collection.insertMany(this.clientSession, documentList);
    }

    @Override
    public BulkWriteResult executeBulkWrite(List<WriteModel<Document>> writeModelList, MongoCollection<Document> collection) {
        return collection.bulkWrite(this.clientSession, writeModelList);
    }

    @Override
    public DeleteResult executeRemove(Bson filter, MongoCollection<Document> collection) {
        return collection.deleteMany(this.clientSession, filter);
    }

    @Override
    public <T> FindIterable<T> executeQuery(Bson queryBasic, BasicDBObject projectionList, BasicDBObject sortCond, Class<T> clazz, MongoCollection<Document> collection) {
        return Optional.ofNullable(queryBasic).map(qb -> collection.find(this.clientSession, qb, clazz)).orElseGet(() -> collection.find(this.clientSession, clazz)).projection((Bson)projectionList).sort((Bson)sortCond);
    }

    @Override
    public <T> AggregateIterable<T> executeAggregate(List<? extends Bson> aggregateConditionList, Class<T> clazz, MongoCollection<Document> collection) {
        return collection.aggregate(this.clientSession, aggregateConditionList, clazz);
    }

    @Override
    public long executeCount(BasicDBObject queryBasic, CountOptions countOptions, MongoCollection<Document> collection) {
        return Optional.ofNullable(countOptions).map(co -> collection.countDocuments(this.clientSession, (Bson)queryBasic, co)).orElseGet(() -> collection.countDocuments(this.clientSession, (Bson)queryBasic));
    }

    @Override
    public long estimatedDocumentCount(MongoCollection<Document> collection) {
        return collection.countDocuments();
    }

    @Override
    public UpdateResult executeUpdate(List<MutablePair<Bson, Bson>> bsonPairList, MongoCollection<Document> collection) {
        AtomicReference<Long> matchedCount = new AtomicReference<Long>(0L);
        AtomicReference<Long> modifiedCount = new AtomicReference<Long>(0L);
        AtomicReference upstartedId = new AtomicReference();
        bsonPairList.forEach(bsonPair -> {
            UpdateResult updateResult = collection.updateMany(this.clientSession, (Bson)bsonPair.getLeft(), (Bson)bsonPair.getRight());
            matchedCount.updateAndGet(v -> v + updateResult.getMatchedCount());
            modifiedCount.updateAndGet(v -> v + updateResult.getModifiedCount());
            upstartedId.set(updateResult.getUpsertedId());
        });
        return UpdateResult.acknowledged((long)matchedCount.get(), (Long)modifiedCount.get(), (BsonValue)((BsonValue)upstartedId.get()));
    }

    @Override
    public String doCreateIndex(Bson bson, MongoCollection<Document> collection) {
        return collection.createIndex(this.clientSession, bson);
    }

    @Override
    public String doCreateIndex(Bson bson, IndexOptions indexOptions, MongoCollection<Document> collection) {
        return collection.createIndex(this.clientSession, bson, indexOptions);
    }

    @Override
    public List<String> doCreateIndexes(List<IndexModel> indexes, MongoCollection<Document> collection) {
        return collection.createIndexes(this.clientSession, indexes);
    }

    @Override
    public List<String> doCreateIndexes(List<IndexModel> indexes, CreateIndexOptions createIndexOptions, MongoCollection<Document> collection) {
        return collection.createIndexes(this.clientSession, indexes, createIndexOptions);
    }

    @Override
    public List<Document> doListIndexes(MongoCollection<Document> collection) {
        return DocumentMapperConvert.indexesIterableToDocument((ListIndexesIterable<Document>)collection.listIndexes(this.clientSession));
    }

    @Override
    public void doDropIndex(String indexName, MongoCollection<Document> collection) {
        collection.dropIndex(this.clientSession, indexName);
    }

    @Override
    public void doDropIndex(String indexName, DropIndexOptions dropIndexOptions, MongoCollection<Document> collection) {
        collection.dropIndex(this.clientSession, indexName, dropIndexOptions);
    }

    @Override
    public void doDropIndex(Bson keys, MongoCollection<Document> collection) {
        collection.dropIndex(this.clientSession, keys);
    }

    @Override
    public void doDropIndex(Bson keys, DropIndexOptions dropIndexOptions, MongoCollection<Document> collection) {
        collection.dropIndex(this.clientSession, keys, dropIndexOptions);
    }

    @Override
    public void doDropIndexes(MongoCollection<Document> collection) {
        collection.dropIndexes(this.clientSession);
    }

    @Override
    public void doDropIndexes(DropIndexOptions dropIndexOptions, MongoCollection<Document> collection) {
        collection.dropIndexes(this.clientSession, dropIndexOptions);
    }
}

