/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.encryptor;

import com.anwen.mongo.cache.global.PropertyCache;
import com.anwen.mongo.encryptor.Encryptor;
import com.anwen.mongo.toolkit.StringUtils;
import java.security.Provider;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Hex;

public class SM4Example
implements Encryptor {
    @Override
    public String encrypt(String data, String key, String publicKey) throws Exception {
        if (StringUtils.isBlank(key)) {
            key = PropertyCache.publicKey;
        }
        byte[] keyBytes = Hex.decode((String)key);
        SecretKeySpec secretKeySpec = new SecretKeySpec(keyBytes, "SM4");
        Cipher cipher = Cipher.getInstance("SM4/ECB/PKCS5Padding", "BC");
        cipher.init(1, secretKeySpec);
        byte[] encryptedBytes = cipher.doFinal(data.getBytes());
        return Hex.toHexString((byte[])encryptedBytes);
    }

    @Override
    public String decrypt(String data, String key, String privateKey) throws Exception {
        if (StringUtils.isBlank(key)) {
            key = PropertyCache.publicKey;
        }
        byte[] keyBytes = Hex.decode((String)key);
        SecretKeySpec secretKeySpec = new SecretKeySpec(keyBytes, "SM4");
        Cipher cipher = Cipher.getInstance("SM4/ECB/PKCS5Padding", "BC");
        cipher.init(2, secretKeySpec);
        byte[] encryptedBytes = Hex.decode((String)data);
        return new String(cipher.doFinal(encryptedBytes));
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

