/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.encryptor;

import com.anwen.mongo.cache.global.PropertyCache;
import com.anwen.mongo.encryptor.Encryptor;
import com.anwen.mongo.toolkit.EncryptorUtil;
import com.anwen.mongo.toolkit.StringUtils;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.spec.ECGenParameterSpec;
import javax.crypto.Cipher;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Hex;

public class SM2Example
implements Encryptor {
    private final String ALGORITHM = "EC";

    public KeyPair generateKeyPair() throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("EC", "BC");
        keyPairGenerator.initialize(new ECGenParameterSpec("sm2p256v1"));
        return keyPairGenerator.generateKeyPair();
    }

    public String encrypt(String data, PublicKey publicKey) throws Exception {
        Cipher cipher = Cipher.getInstance("SM2", "BC");
        cipher.init(1, publicKey);
        return Hex.toHexString((byte[])cipher.doFinal(data.getBytes()));
    }

    @Override
    public String encrypt(String data, String key, String publicKey) throws Exception {
        if (StringUtils.isBlank(publicKey)) {
            publicKey = PropertyCache.publicKey;
        }
        return this.encrypt(data, EncryptorUtil.getPublicKeyFromString(publicKey, "EC", "BC"));
    }

    public String decrypt(String data, PrivateKey privateKey) throws Exception {
        Cipher cipher = Cipher.getInstance("SM2", "BC");
        cipher.init(2, privateKey);
        return new String(cipher.doFinal(Hex.decode((String)data)));
    }

    @Override
    public String decrypt(String data, String key, String privateKey) throws Exception {
        if (StringUtils.isBlank(privateKey)) {
            privateKey = PropertyCache.publicKey;
        }
        return this.decrypt(data, EncryptorUtil.getPrivateKeyFromString(privateKey, "EC", "BC"));
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

