/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.encryptor;

import com.anwen.mongo.cache.global.PropertyCache;
import com.anwen.mongo.encryptor.Encryptor;
import com.anwen.mongo.toolkit.EncryptorUtil;
import com.anwen.mongo.toolkit.StringUtils;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.Cipher;

public class RSAExample
implements Encryptor {
    private final String ALGORITHM = "RSA";

    public String encrypt(String data, PublicKey publicKey) throws Exception {
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(1, publicKey);
        return StringUtils.bytesToHex(cipher.doFinal(data.getBytes()));
    }

    @Override
    public String encrypt(String data, String key, String publicKey) throws Exception {
        if (StringUtils.isBlank(publicKey)) {
            publicKey = PropertyCache.publicKey;
        }
        return this.encrypt(data, EncryptorUtil.getPublicKeyFromString(publicKey, "RSA"));
    }

    public String decrypt(String encryptedData, PrivateKey privateKey) throws Exception {
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(2, privateKey);
        return new String(cipher.doFinal(StringUtils.hexToBytes(encryptedData)));
    }

    @Override
    public String decrypt(String encryptedData, String key, String privateKey) throws Exception {
        if (StringUtils.isBlank(privateKey)) {
            privateKey = PropertyCache.publicKey;
        }
        return this.decrypt(encryptedData, EncryptorUtil.getPrivateKeyFromString(privateKey, "RSA"));
    }

    public KeyPair generateKeyPair() throws Exception {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
        keyGen.initialize(2048);
        return keyGen.generateKeyPair();
    }
}

