/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.encryptor;

import com.anwen.mongo.cache.global.PropertyCache;
import com.anwen.mongo.encryptor.Encryptor;
import com.anwen.mongo.toolkit.StringUtils;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public class PBEExample
implements Encryptor {
    private final String algorithm;
    private static final int ITERATION_COUNT = 1000;

    public PBEExample(String algorithm) {
        this.algorithm = algorithm;
    }

    private static byte[] generateSalt() {
        byte[] salt = new byte[8];
        SecureRandom random = new SecureRandom();
        random.nextBytes(salt);
        return salt;
    }

    @Override
    public String encrypt(String data, String key, String publicKey) throws Exception {
        byte[] salt = PBEExample.generateSalt();
        PBEParameterSpec pbeParamSpec = new PBEParameterSpec(salt, 1000);
        if (StringUtils.isBlank(key)) {
            key = PropertyCache.key;
        }
        PBEKeySpec pbeKeySpec = new PBEKeySpec(key.toCharArray());
        SecretKeyFactory keyFac = SecretKeyFactory.getInstance(this.algorithm);
        SecretKey pbeKey = keyFac.generateSecret(pbeKeySpec);
        Cipher cipher = Cipher.getInstance(this.algorithm);
        cipher.init(1, (Key)pbeKey, pbeParamSpec);
        byte[] encryptedBytes = cipher.doFinal(data.getBytes());
        byte[] encryptedWithSalt = new byte[salt.length + encryptedBytes.length];
        System.arraycopy(salt, 0, encryptedWithSalt, 0, salt.length);
        System.arraycopy(encryptedBytes, 0, encryptedWithSalt, salt.length, encryptedBytes.length);
        return StringUtils.bytesToHex(encryptedWithSalt);
    }

    @Override
    public String decrypt(String data, String key, String privateKey) throws Exception {
        byte[] encryptedWithSalt = StringUtils.hexToBytes(data);
        byte[] salt = new byte[8];
        byte[] encryptedBytes = new byte[encryptedWithSalt.length - salt.length];
        System.arraycopy(encryptedWithSalt, 0, salt, 0, salt.length);
        System.arraycopy(encryptedWithSalt, salt.length, encryptedBytes, 0, encryptedBytes.length);
        PBEParameterSpec pbeParamSpec = new PBEParameterSpec(salt, 1000);
        PBEKeySpec pbeKeySpec = new PBEKeySpec(key.toCharArray());
        SecretKeyFactory keyFac = SecretKeyFactory.getInstance(this.algorithm);
        SecretKey pbeKey = keyFac.generateSecret(pbeKeySpec);
        Cipher cipher = Cipher.getInstance(this.algorithm);
        cipher.init(2, (Key)pbeKey, pbeParamSpec);
        byte[] decryptedBytes = cipher.doFinal(encryptedBytes);
        return new String(decryptedBytes);
    }
}

