/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.encryptor;

import com.anwen.mongo.cache.global.PropertyCache;
import com.anwen.mongo.encryptor.Encryptor;
import com.anwen.mongo.toolkit.StringUtils;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class AESExample
implements Encryptor {
    private final String ALGORITHM = "AES";

    @Override
    public String encrypt(String data, String password, String publicKey) throws Exception {
        Cipher cipher = Cipher.getInstance("AES");
        if (StringUtils.isBlank(password)) {
            password = PropertyCache.key;
        }
        cipher.init(1, this.getKeyFromPassword(password));
        return StringUtils.bytesToHex(cipher.doFinal(data.getBytes()));
    }

    @Override
    public String decrypt(String encryptedData, String password, String privateKey) throws Exception {
        Cipher cipher = Cipher.getInstance("AES");
        if (StringUtils.isBlank(password)) {
            password = PropertyCache.key;
        }
        cipher.init(2, this.getKeyFromPassword(password));
        return new String(cipher.doFinal(StringUtils.hexToBytes(encryptedData)));
    }

    public SecretKey getKeyFromPassword(String password) throws NoSuchAlgorithmException {
        byte[] key = password.getBytes();
        MessageDigest sha = MessageDigest.getInstance("SHA-256");
        key = sha.digest(key);
        key = Arrays.copyOf(key, 16);
        return new SecretKeySpec(key, "AES");
    }
}

