/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.context;

import com.anwen.mongo.cache.global.DataSourceNameCache;
import com.mongodb.client.ClientSession;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MongoTransactionStatus {
    private final Map<String, ClientSession> clientSessionMap = new ConcurrentHashMap<String, ClientSession>();
    private long referenceCount;

    public MongoTransactionStatus(ClientSession clientSession) {
        this.clientSessionMap.put(DataSourceNameCache.getDataSource(), clientSession);
        this.referenceCount = 0L;
    }

    public ClientSession getClientSession() {
        return this.clientSessionMap.get(DataSourceNameCache.getDataSource());
    }

    public void incrementReference() {
        ++this.referenceCount;
    }

    public void decrementReference() {
        --this.referenceCount;
    }

    public void clearReference() {
        this.referenceCount = 0L;
    }

    public boolean readyCommit() {
        return this.referenceCount == 0L;
    }

    public boolean readyClose() {
        return this.referenceCount <= 0L;
    }
}

