/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.conn;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import org.bson.Document;

public class ConnectMongoDB {
    private final MongoClient mongoClient;
    private final String database;
    private final String collection;
    private MongoDatabase mongoDatabase;

    public MongoClient getMongoClient() {
        return this.mongoClient;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getCollection() {
        return this.collection;
    }

    public MongoDatabase getMongoDatabase() {
        return this.mongoDatabase;
    }

    public ConnectMongoDB(MongoClient mongoClient, String database, String collectionValue) {
        this.mongoClient = mongoClient;
        this.database = database;
        this.collection = collectionValue;
    }

    public MongoCollection<Document> open() {
        return this.open(this.mongoClient.getDatabase(this.database));
    }

    public MongoCollection<Document> open(MongoDatabase mongoDatabase) {
        return mongoDatabase.getCollection(this.collection, Document.class);
    }

    public boolean isSame(String database, String collection) {
        return this.database.equals(database) && this.collection.equals(collection);
    }
}

