/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.conn;

import com.anwen.mongo.cache.global.CollectionLogicDeleteCache;
import com.anwen.mongo.conn.ConnectMongoDB;
import com.anwen.mongo.factory.MongoClientFactory;
import com.anwen.mongo.handlers.collection.AnnotationOperate;
import com.anwen.mongo.logic.UnClassCollection;
import com.mongodb.client.MongoCollection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bson.Document;

public class CollectionManager {
    private final Map<String, MongoCollection<Document>> collectionMap = new ConcurrentHashMap<String, MongoCollection<Document>>();
    private final String database;

    public CollectionManager(String database) {
        this.database = database;
    }

    public void setCollectionMap(String key, MongoCollection<Document> value) {
        this.collectionMap.put(key, value);
    }

    public MongoCollection<Document> getCollection(Class<?> clazz) {
        return this.getCollection(AnnotationOperate.getCollectionName(clazz));
    }

    public MongoCollection<Document> getCollection(String collectionName) {
        MongoCollection<Document> mongoCollection;
        if (!this.collectionMap.containsKey(collectionName)) {
            mongoCollection = new ConnectMongoDB(MongoClientFactory.getInstance().getMongoClient(), this.database, collectionName).open();
            this.collectionMap.put(collectionName, mongoCollection);
            CollectionLogicDeleteCache.mapperClassByCollection(mongoCollection.getNamespace().getFullName(), UnClassCollection.class);
        } else {
            mongoCollection = this.collectionMap.get(collectionName);
        }
        return mongoCollection;
    }
}

