/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.config;

import com.anwen.mongo.annotation.collection.CollectionLogic;
import com.anwen.mongo.aware.Aware;
import com.anwen.mongo.cache.global.AwareHandlerCache;
import com.anwen.mongo.cache.global.CollectionLogicDeleteCache;
import com.anwen.mongo.cache.global.ConversionCache;
import com.anwen.mongo.cache.global.ExecutorReplacerCache;
import com.anwen.mongo.cache.global.HandlerCache;
import com.anwen.mongo.cache.global.InterceptorCache;
import com.anwen.mongo.cache.global.ListenerCache;
import com.anwen.mongo.cache.global.MongoPlusClientCache;
import com.anwen.mongo.conn.CollectionManager;
import com.anwen.mongo.domain.InitMongoLogicException;
import com.anwen.mongo.domain.InitMongoPlusException;
import com.anwen.mongo.enums.CollectionNameConvertEnum;
import com.anwen.mongo.factory.MongoClientFactory;
import com.anwen.mongo.handlers.MetaObjectHandler;
import com.anwen.mongo.handlers.TenantHandler;
import com.anwen.mongo.handlers.collection.AnnotationOperate;
import com.anwen.mongo.interceptor.Interceptor;
import com.anwen.mongo.interceptor.business.CollectionLogiceInterceptor;
import com.anwen.mongo.interceptor.business.LogicAutoFillInterceptor;
import com.anwen.mongo.interceptor.business.TenantInterceptor;
import com.anwen.mongo.listener.BaseListener;
import com.anwen.mongo.listener.Listener;
import com.anwen.mongo.listener.business.BlockAttackInnerListener;
import com.anwen.mongo.listener.business.LogListener;
import com.anwen.mongo.logic.replacer.LogicRemoveReplacer;
import com.anwen.mongo.manager.MongoPlusClient;
import com.anwen.mongo.mapper.BaseMapper;
import com.anwen.mongo.mapper.DefaultBaseMapperImpl;
import com.anwen.mongo.mapping.FieldInformation;
import com.anwen.mongo.mapping.MappingMongoConverter;
import com.anwen.mongo.mapping.MongoConverter;
import com.anwen.mongo.mapping.TypeInformation;
import com.anwen.mongo.model.BaseProperty;
import com.anwen.mongo.model.LogicDeleteResult;
import com.anwen.mongo.model.LogicProperty;
import com.anwen.mongo.replacer.Replacer;
import com.anwen.mongo.strategy.conversion.ConversionStrategy;
import com.anwen.mongo.toolkit.ClassTypeUtil;
import com.anwen.mongo.toolkit.StringUtils;
import com.anwen.mongo.toolkit.UrlJoint;
import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoDatabase;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class Configuration {
    private String url;
    private BaseProperty baseProperty = new BaseProperty();
    private LogicProperty logicProperty = new LogicProperty();

    public static Configuration builder() {
        return new Configuration();
    }

    public Configuration connection(String url) {
        this.url = url;
        return this;
    }

    public Configuration connection(BaseProperty baseProperty) {
        this.baseProperty = baseProperty;
        UrlJoint urlJoint = new UrlJoint(baseProperty);
        return this.connection(urlJoint.jointMongoUrl());
    }

    public Configuration database(String database) {
        this.baseProperty.setDatabase(database);
        return this;
    }

    public Configuration collectionNameConvert(CollectionNameConvertEnum collectionNameConvertEnum) {
        AnnotationOperate.setCollectionNameConvertEnum(collectionNameConvertEnum);
        return this;
    }

    @SafeVarargs
    public final Configuration convert(Class<? extends ConversionStrategy<?>> ... clazzConversions) {
        block0: for (Class<ConversionStrategy<?>> clazz : clazzConversions) {
            Type[] genericInterfaces;
            for (Type anInterface : genericInterfaces = clazz.getGenericInterfaces()) {
                ParameterizedType parameterizedType = (ParameterizedType)anInterface;
                if (!parameterizedType.getRawType().equals(ConversionStrategy.class)) continue;
                Class clazz2 = (Class)parameterizedType.getActualTypeArguments()[0];
                ConversionCache.putConversionStrategy(clazz2, (ConversionStrategy)ClassTypeUtil.getInstanceByClass(clazz));
                continue block0;
            }
        }
        return this;
    }

    public Configuration metaObjectHandler(MetaObjectHandler metaObjectHandler) {
        HandlerCache.metaObjectHandler = metaObjectHandler;
        return this;
    }

    public Configuration log() {
        ListenerCache.listeners.add(new LogListener());
        return this;
    }

    public Configuration log(Boolean pretty) {
        ListenerCache.listeners.add(new LogListener(pretty));
        return this;
    }

    public Configuration blockAttackInner() {
        ListenerCache.listeners.add(new BlockAttackInnerListener());
        return this;
    }

    @SafeVarargs
    public final Configuration listener(Class<? extends Listener> ... listeners) {
        for (Class<? extends Listener> listener : listeners) {
            ListenerCache.listeners.add((Listener)ClassTypeUtil.getInstanceByClass(listener));
        }
        return this;
    }

    @SafeVarargs
    public final Configuration interceptor(Class<? extends Interceptor> ... interceptors) {
        for (Class<? extends Interceptor> interceptor : interceptors) {
            InterceptorCache.interceptors.add((Interceptor)ClassTypeUtil.getInstanceByClass(interceptor));
        }
        InterceptorCache.sorted();
        return this;
    }

    public Configuration tenantHandler(TenantHandler tenantHandler) {
        InterceptorCache.interceptors.add(new TenantInterceptor(tenantHandler));
        return this;
    }

    @SafeVarargs
    public final Configuration replacer(Class<? extends Replacer> ... replacers) {
        for (Class<? extends Replacer> replacer : replacers) {
            ExecutorReplacerCache.replacers.add((Replacer)ClassTypeUtil.getInstanceByClass(replacer));
        }
        ExecutorReplacerCache.sorted();
        return this;
    }

    public MongoPlusClient getMongoPlusClient() {
        if (StringUtils.isBlank(this.url)) {
            throw new InitMongoPlusException("Connection URL not configured");
        }
        if (StringUtils.isBlank(this.baseProperty.getDatabase())) {
            throw new InitMongoPlusException("Connection database not configured");
        }
        return this.initMongoPlusClient();
    }

    public MongoPlusClient initMongoPlusClient() {
        return this.initMongoPlusClient(MongoClients.create((MongoClientSettings)MongoClientSettings.builder().applyConnectionString(new ConnectionString(this.url)).commandListenerList(Collections.singletonList(new BaseListener())).build()), this.baseProperty);
    }

    public MongoPlusClient initMongoPlusClient(BaseProperty baseProperty) {
        return this.initMongoPlusClient(MongoClients.create((MongoClientSettings)MongoClientSettings.builder().applyConnectionString(new ConnectionString(this.url)).commandListenerList(Collections.singletonList(new BaseListener())).build()), baseProperty);
    }

    public MongoPlusClient initMongoPlusClient(MongoClient mongoClient, BaseProperty baseProperty) {
        if (StringUtils.isBlank(baseProperty.getDatabase())) {
            throw new InitMongoPlusException("Connection database not configured");
        }
        MongoClientFactory.getInstance(mongoClient);
        final MongoPlusClient mongoPlusClient = new MongoPlusClient();
        mongoPlusClient.setBaseProperty(baseProperty);
        final ArrayList<MongoDatabase> mongoDatabaseList = new ArrayList<MongoDatabase>();
        mongoPlusClient.setCollectionManagerMap((Map<String, Map<String, CollectionManager>>)new ConcurrentHashMap<String, Map<String, CollectionManager>>(){
            {
                this.put("master", new LinkedHashMap<String, CollectionManager>(){
                    {
                        String database = mongoPlusClient.getBaseProperty().getDatabase();
                        Arrays.stream(database.split(",")).collect(Collectors.toList()).forEach((? super T db) -> {
                            CollectionManager collectionManager = new CollectionManager((String)db);
                            MongoDatabase mongoDatabase = mongoPlusClient.getMongoClient().getDatabase(db);
                            mongoDatabaseList.add(mongoDatabase);
                            this.put(db, collectionManager);
                        });
                    }
                });
            }
        });
        mongoPlusClient.setMongoDatabase(mongoDatabaseList);
        MongoPlusClientCache.mongoPlusClient = mongoPlusClient;
        return mongoPlusClient;
    }

    public void setOtherDataSource(Map<String, MongoClient> mongoClientMap) {
        MongoClientFactory.getInstance(mongoClientMap);
    }

    public BaseMapper getBaseMapper() {
        return new DefaultBaseMapperImpl(this.getMongoPlusClient(), new MappingMongoConverter(this.getMongoPlusClient()));
    }

    public BaseMapper getBaseMapper(MongoConverter mongoConverter) {
        return new DefaultBaseMapperImpl(this.getMongoPlusClient(), mongoConverter);
    }

    public Configuration logic(LogicProperty logicProperty) {
        if (Objects.isNull(logicProperty)) {
            throw new InitMongoLogicException("Config logic logicProperty not null");
        }
        this.logicProperty = logicProperty;
        CollectionLogicDeleteCache.open = logicProperty.getOpen();
        CollectionLogicDeleteCache.logicProperty = logicProperty;
        if (logicProperty.getOpen().booleanValue()) {
            InterceptorCache.interceptors.add(new CollectionLogiceInterceptor());
            if (logicProperty.getAutoFill().booleanValue()) {
                InterceptorCache.interceptors.add(new LogicAutoFillInterceptor());
            }
            InterceptorCache.sorted();
            ExecutorReplacerCache.replacers.add(new LogicRemoveReplacer());
            ExecutorReplacerCache.sorted();
        }
        return this;
    }

    public Configuration setLogicFiled(Class<?> ... collectionClasses) {
        return this.setLogicFiled(this.logicProperty, collectionClasses);
    }

    public Configuration setLogicFiled(LogicProperty logicProperty, Class<?> ... collectionClasses) {
        if (Objects.isNull(collectionClasses) || Objects.isNull(logicProperty) || !logicProperty.getOpen().booleanValue()) {
            return this;
        }
        Map<Class<?>, LogicDeleteResult> logicDeleteResultHashMap = CollectionLogicDeleteCache.logicDeleteResultHashMap;
        for (Class<?> clazz : collectionClasses) {
            if (logicDeleteResultHashMap.containsKey(clazz)) continue;
            TypeInformation typeInformation = TypeInformation.of(clazz);
            FieldInformation annotationField = typeInformation.getAnnotationField(CollectionLogic.class);
            if (Objects.nonNull(annotationField)) {
                CollectionLogic annotation = annotationField.getAnnotation(CollectionLogic.class);
                if (annotation.close()) continue;
                LogicDeleteResult result = new LogicDeleteResult();
                String column = annotationField.getName();
                result.setColumn(column);
                result.setLogicDeleteValue(StringUtils.isNotBlank(annotation.delval()) ? annotation.delval() : logicProperty.getLogicDeleteValue());
                result.setLogicNotDeleteValue(StringUtils.isNotBlank(annotation.value()) ? annotation.value() : logicProperty.getLogicNotDeleteValue());
                logicDeleteResultHashMap.put(clazz, result);
                continue;
            }
            if (StringUtils.isNotEmpty(logicProperty.getLogicDeleteField()) && StringUtils.isNotEmpty(logicProperty.getLogicDeleteValue()) && StringUtils.isNotEmpty(logicProperty.getLogicNotDeleteValue())) {
                LogicDeleteResult result = new LogicDeleteResult();
                result.setColumn(logicProperty.getLogicDeleteField());
                result.setLogicDeleteValue(logicProperty.getLogicDeleteValue());
                result.setLogicNotDeleteValue(logicProperty.getLogicNotDeleteValue());
                logicDeleteResultHashMap.put(clazz, result);
                continue;
            }
            logicDeleteResultHashMap.put(clazz, null);
        }
        return this;
    }

    public Configuration aware(Aware aware) {
        AwareHandlerCache.putAware(aware);
        return this;
    }
}

