/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.cache.global;

import com.anwen.mongo.domain.MongoPlusDsException;
import com.anwen.mongo.model.BaseProperty;
import com.anwen.mongo.toolkit.StringUtils;
import java.util.HashMap;
import java.util.Map;

public class DataSourceNameCache {
    private static final ThreadLocal<String> dataSource = new InheritableThreadLocal<String>();
    private static final Map<String, BaseProperty> basePropertyMap = new HashMap<String, BaseProperty>();

    public static void setBaseProperty(String ds, BaseProperty baseProperty) {
        basePropertyMap.put(ds, baseProperty);
    }

    public static BaseProperty getBaseProperty(String ds) {
        return basePropertyMap.get(ds);
    }

    public static void setDataSource(String ds) {
        dataSource.set(ds);
    }

    public static String getDatabase() {
        String currentDataSource = DataSourceNameCache.getDataSource();
        BaseProperty baseProperty = basePropertyMap.get(currentDataSource);
        if (baseProperty == null) {
            throw new MongoPlusDsException("The " + currentDataSource + " data source does not exist");
        }
        return baseProperty.getDatabase();
    }

    public static String getDataSource() {
        String ds = dataSource.get();
        if (StringUtils.isBlank(ds)) {
            ds = "master";
        }
        return ds;
    }

    public static void clear() {
        dataSource.remove();
    }
}

