/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.cache.global;

import com.anwen.mongo.strategy.conversion.ConversionStrategy;
import com.anwen.mongo.strategy.conversion.impl.BigDecimalConversionStrategy;
import com.anwen.mongo.strategy.conversion.impl.BigIntegerConversionStrategy;
import com.anwen.mongo.strategy.conversion.impl.BooleanConversionStrategy;
import com.anwen.mongo.strategy.conversion.impl.ByteArrayConversionStrategy;
import com.anwen.mongo.strategy.conversion.impl.ByteConversionStrategy;
import com.anwen.mongo.strategy.conversion.impl.DateConversionStrategy;
import com.anwen.mongo.strategy.conversion.impl.DefaultConversionStrategy;
import com.anwen.mongo.strategy.conversion.impl.DocumentConversionStrategy;
import com.anwen.mongo.strategy.conversion.impl.DoubleConversionStrategy;
import com.anwen.mongo.strategy.conversion.impl.EnumConversionStrategy;
import com.anwen.mongo.strategy.conversion.impl.FloatConversionStrategy;
import com.anwen.mongo.strategy.conversion.impl.InstantConversionStrategy;
import com.anwen.mongo.strategy.conversion.impl.IntegerConversionStrategy;
import com.anwen.mongo.strategy.conversion.impl.LocalDateConversionStrategy;
import com.anwen.mongo.strategy.conversion.impl.LocalDateTimeConversionStrategy;
import com.anwen.mongo.strategy.conversion.impl.LocalTimeConversionStrategy;
import com.anwen.mongo.strategy.conversion.impl.LongConversionStrategy;
import com.anwen.mongo.strategy.conversion.impl.StringConversionStrategy;
import com.anwen.mongo.strategy.conversion.impl.bson.BsonBooleanConversionStrategy;
import com.anwen.mongo.strategy.conversion.impl.bson.BsonDateTimeConversionStrategy;
import com.anwen.mongo.strategy.conversion.impl.bson.BsonDoubleConversionStrategy;
import com.anwen.mongo.strategy.conversion.impl.bson.BsonInt32ConversionStrategy;
import com.anwen.mongo.strategy.conversion.impl.bson.BsonInt64ConversionStrategy;
import com.anwen.mongo.strategy.conversion.impl.bson.BsonStringConversionStrategy;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.bson.BsonBoolean;
import org.bson.BsonDateTime;
import org.bson.BsonDouble;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonString;
import org.bson.Document;

public class ConversionCache {
    private static final Map<Class<?>, ConversionStrategy<?>> conversionStrategieMap = new HashMap();

    public static ConversionStrategy<?> getConversionStrategy(Class<?> clazz) {
        return conversionStrategieMap.get(clazz);
    }

    public static void putConversionStrategy(Class<?> clazz, ConversionStrategy<?> conversionStrategy) {
        conversionStrategieMap.put(clazz, conversionStrategy);
    }

    static {
        conversionStrategieMap.put(Integer.class, new IntegerConversionStrategy());
        conversionStrategieMap.put(Long.class, new LongConversionStrategy());
        conversionStrategieMap.put(Double.class, new DoubleConversionStrategy());
        conversionStrategieMap.put(Float.class, new FloatConversionStrategy());
        conversionStrategieMap.put(Boolean.class, new BooleanConversionStrategy());
        conversionStrategieMap.put(String.class, new StringConversionStrategy());
        conversionStrategieMap.put(LocalTime.class, new LocalTimeConversionStrategy());
        conversionStrategieMap.put(LocalDate.class, new LocalDateConversionStrategy());
        conversionStrategieMap.put(LocalDateTime.class, new LocalDateTimeConversionStrategy());
        conversionStrategieMap.put(Date.class, new DateConversionStrategy());
        conversionStrategieMap.put(Instant.class, new InstantConversionStrategy());
        conversionStrategieMap.put(Object.class, new DefaultConversionStrategy());
        conversionStrategieMap.put(BigDecimal.class, new BigDecimalConversionStrategy());
        conversionStrategieMap.put(BigInteger.class, new BigIntegerConversionStrategy());
        conversionStrategieMap.put(Enum.class, new EnumConversionStrategy());
        conversionStrategieMap.put(Document.class, new DocumentConversionStrategy());
        conversionStrategieMap.put(byte[].class, new ByteArrayConversionStrategy());
        conversionStrategieMap.put(Byte.class, new ByteConversionStrategy());
        conversionStrategieMap.put(BsonBoolean.class, new BsonBooleanConversionStrategy());
        conversionStrategieMap.put(BsonDateTime.class, new BsonDateTimeConversionStrategy());
        conversionStrategieMap.put(BsonDouble.class, new BsonDoubleConversionStrategy());
        conversionStrategieMap.put(BsonInt32.class, new BsonInt32ConversionStrategy());
        conversionStrategieMap.put(BsonInt64.class, new BsonInt64ConversionStrategy());
        conversionStrategieMap.put(BsonString.class, new BsonStringConversionStrategy());
    }
}

