/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.cache.global;

import com.anwen.mongo.aware.Aware;
import com.anwen.mongo.toolkit.ClassTypeUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class AwareHandlerCache<T extends Aware> {
    private final Map<Class<T>, List<T>> handlerMap = new ConcurrentHashMap<Class<T>, List<T>>();
    private static final AwareHandlerCache instant = new AwareHandlerCache();

    private AwareHandlerCache() {
    }

    public static AwareHandlerCache getInstance() {
        return instant;
    }

    public static <T extends Aware> List<T> listHandlers(Class<T> clazz) {
        List<T> o = AwareHandlerCache.getInstance().handlerMap.get(clazz);
        if (Objects.isNull(o)) {
            return Collections.emptyList();
        }
        return o;
    }

    public static synchronized <T extends Aware> void putAware(T aware) {
        Class<?>[] interfaces;
        for (Class<?> anInterface : interfaces = aware.getClass().getInterfaces()) {
            List<T> handlers;
            if (!ClassTypeUtil.isTargetClass(Aware.class, anInterface).booleanValue()) continue;
            List<T> o = AwareHandlerCache.getInstance().handlerMap.get(anInterface);
            if (Objects.nonNull(o)) {
                handlers = o;
            } else {
                handlers = new ArrayList<T>();
                AwareHandlerCache.getInstance().handlerMap.put(anInterface, handlers);
            }
            handlers.add(aware);
        }
    }
}

