/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.cache.codec;

import java.util.ArrayList;
import java.util.List;
import org.bson.codecs.BsonCodecProvider;
import org.bson.codecs.BsonValueCodecProvider;
import org.bson.codecs.DocumentCodecProvider;
import org.bson.codecs.IterableCodecProvider;
import org.bson.codecs.JsonObjectCodecProvider;
import org.bson.codecs.MapCodecProvider;
import org.bson.codecs.ValueCodecProvider;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.codecs.jsr310.Jsr310CodecProvider;

public class MapCodecCache {
    private static final List<CodecProvider> codecProviderList = new ArrayList<CodecProvider>(){
        {
            this.add(new ValueCodecProvider());
            this.add(new BsonValueCodecProvider());
            this.add(new DocumentCodecProvider());
            this.add(new IterableCodecProvider());
            this.add(new MapCodecProvider());
            this.add(new Jsr310CodecProvider());
            this.add(new JsonObjectCodecProvider());
            this.add(new BsonCodecProvider());
        }
    };
    private static CodecRegistry DEFAULT_CODEC_REGISTRY;

    public static List<CodecProvider> getAllCodecProvider() {
        return codecProviderList;
    }

    public static void addCodecProvider(CodecProvider codecProvider) {
        codecProviderList.add(codecProvider);
    }

    public static CodecRegistry getDefaultCodecRegistry() {
        if (DEFAULT_CODEC_REGISTRY == null) {
            DEFAULT_CODEC_REGISTRY = CodecRegistries.fromProviders(codecProviderList);
        }
        return DEFAULT_CODEC_REGISTRY;
    }
}

