/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.aggregate.pipeline;

import com.anwen.mongo.conditions.interfaces.condition.Order;
import com.anwen.mongo.support.SFunction;
import com.mongodb.assertions.Assertions;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

public class Sorts {
    public static Bson asc(String ... fieldNames) {
        return Sorts.asc(Arrays.asList(fieldNames));
    }

    @SafeVarargs
    public static <T> Bson asc(SFunction<T, ?> ... fieldNames) {
        return Sorts.asc((String[])Arrays.stream(fieldNames).map(SFunction::getFieldNameLine).toArray(String[]::new));
    }

    public static <T> Bson ascLambda(List<SFunction<T, ?>> fieldNames) {
        return Sorts.asc(fieldNames.stream().map(SFunction::getFieldNameLine).collect(Collectors.toList()));
    }

    public static Bson asc(List<String> fieldNames) {
        Assertions.notNull((String)"fieldNames", fieldNames);
        return Sorts.orderBy(fieldNames, (BsonValue)new BsonInt32(1));
    }

    public static Bson desc(String ... fieldNames) {
        return Sorts.desc(Arrays.asList(fieldNames));
    }

    @SafeVarargs
    public static <T> Bson desc(SFunction<T, ?> ... fieldNames) {
        return Sorts.desc(Arrays.stream(fieldNames).map(SFunction::getFieldNameLine).collect(Collectors.toList()));
    }

    public static <T> Bson descLambda(List<SFunction<T, ?>> fieldNames) {
        return Sorts.desc(fieldNames.stream().map(SFunction::getFieldNameLine).collect(Collectors.toList()));
    }

    public static Bson desc(List<String> fieldNames) {
        Assertions.notNull((String)"fieldNames", fieldNames);
        return Sorts.orderBy(fieldNames, (BsonValue)new BsonInt32(-1));
    }

    public static Bson metaTextScore(String fieldName) {
        return new BsonDocument(fieldName, (BsonValue)new BsonDocument("$meta", (BsonValue)new BsonString("textScore")));
    }

    public static <T> Bson metaTextScore(SFunction<T, ?> fieldName) {
        return Sorts.metaTextScore(fieldName.getFieldNameLine());
    }

    public static Bson orderBy(Bson ... sorts) {
        return Sorts.orderBy(Arrays.asList(sorts));
    }

    public static Bson orderBy(Order ... orders) {
        return Sorts.orderBy(Arrays.stream(orders).map(order -> new BsonDocument(order.getColumn(), (BsonValue)new BsonInt32(order.getType().intValue()))).collect(Collectors.toList()));
    }

    public static Bson orderBy(List<? extends Bson> sorts) {
        Assertions.notNull((String)"sorts", sorts);
        return new CompoundSort(sorts);
    }

    private static Bson orderBy(List<String> fieldNames, BsonValue value) {
        BsonDocument document = new BsonDocument();
        for (String fieldName : fieldNames) {
            document.append(fieldName, value);
        }
        return document;
    }

    private static final class CompoundSort
    implements Bson {
        private final List<? extends Bson> sorts;

        private CompoundSort(List<? extends Bson> sorts) {
            this.sorts = sorts;
        }

        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry codecRegistry) {
            BsonDocument combinedDocument = new BsonDocument();
            for (Bson bson : this.sorts) {
                BsonDocument sortDocument = bson.toBsonDocument(documentClass, codecRegistry);
                for (String key : sortDocument.keySet()) {
                    combinedDocument.append(key, sortDocument.get((Object)key));
                }
            }
            return combinedDocument;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CompoundSort that = (CompoundSort)o;
            return Objects.equals(this.sorts, that.sorts);
        }

        public int hashCode() {
            return this.sorts != null ? this.sorts.hashCode() : 0;
        }

        public String toString() {
            return "Compound Sort{sorts=" + this.sorts + '}';
        }
    }
}

