/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.aggregate.pipeline;

import com.anwen.mongo.aggregate.pipeline.SimpleExpression;
import com.anwen.mongo.conditions.query.QueryChainWrapper;
import com.anwen.mongo.handlers.condition.BuildCondition;
import com.anwen.mongo.support.SFunction;
import com.mongodb.assertions.Assertions;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

public class Projections {
    public static <TExpression> Bson computed(String fieldName, TExpression expression) {
        return new SimpleExpression<TExpression>(fieldName, expression);
    }

    public static <TExpression, T> Bson computed(SFunction<T, ?> fieldName, TExpression expression) {
        return Projections.computed(fieldName.getFieldNameLine(), expression);
    }

    public static Bson computedSearchMeta(String fieldName) {
        return Projections.computed(fieldName, "$$SEARCH_META");
    }

    public static <T> Bson computedSearchMeta(SFunction<T, ?> fieldName) {
        return Projections.computed(fieldName, "$$SEARCH_META");
    }

    public static Bson include(String ... fieldNames) {
        return Projections.include(Arrays.asList(fieldNames));
    }

    @SafeVarargs
    public static <T> Bson include(SFunction<T, ?> ... fieldNames) {
        return Projections.include((String[])Arrays.stream(fieldNames).map(SFunction::getFieldNameLine).toArray(String[]::new));
    }

    public static Bson include(List<String> fieldNames) {
        return Projections.combine(fieldNames, (BsonValue)new BsonInt32(1));
    }

    public static <T> Bson includeLambda(List<SFunction<T, ?>> fieldNames) {
        return Projections.combine(fieldNames.stream().map(SFunction::getFieldNameLine).collect(Collectors.toList()), (BsonValue)new BsonInt32(1));
    }

    public static Bson exclude(String ... fieldNames) {
        return Projections.exclude(Arrays.asList(fieldNames));
    }

    @SafeVarargs
    public static <T> Bson exclude(SFunction<T, ?> ... fieldNames) {
        return Projections.exclude((String[])Arrays.stream(fieldNames).map(SFunction::getFieldNameLine).toArray(String[]::new));
    }

    public static Bson exclude(List<String> fieldNames) {
        return Projections.combine(fieldNames, (BsonValue)new BsonInt32(0));
    }

    public static <T> Bson excludeLambda(List<SFunction<T, ?>> fieldNames) {
        return Projections.combine(fieldNames.stream().map(SFunction::getFieldNameLine).collect(Collectors.toList()), (BsonValue)new BsonInt32(0));
    }

    public static Bson excludeId() {
        return new BsonDocument("_id", (BsonValue)new BsonInt32(0));
    }

    public static Bson elemMatch(String fieldName) {
        return new BsonDocument(fieldName + ".$", (BsonValue)new BsonInt32(1));
    }

    public static <T> Bson elemMatch(SFunction<T, ?> fieldName) {
        return Projections.elemMatch(fieldName.getFieldNameLine());
    }

    public static Bson elemMatch(String fieldName, Bson filter) {
        return new ElemMatchFilterProjection(fieldName, filter);
    }

    public static Bson elemMatch(String fieldName, QueryChainWrapper<?, ?> queryChainWrapper) {
        return Projections.elemMatch(fieldName, (Bson)BuildCondition.condition().queryCondition(queryChainWrapper.getCompareList()));
    }

    public static <T> Bson elemMatch(SFunction<T, ?> fieldName, Bson filter) {
        return Projections.elemMatch(fieldName.getFieldNameLine(), filter);
    }

    public static <T> Bson elemMatch(SFunction<T, ?> fieldName, QueryChainWrapper<?, ?> queryChainWrapper) {
        return Projections.elemMatch(fieldName.getFieldNameLine(), queryChainWrapper);
    }

    public static Bson meta(String fieldName, String metaFieldName) {
        return new BsonDocument(fieldName, (BsonValue)new BsonDocument("$meta", (BsonValue)new BsonString(metaFieldName)));
    }

    public static <T> Bson meta(SFunction<T, ?> fieldName, String metaFieldName) {
        return Projections.meta(fieldName.getFieldNameLine(), metaFieldName);
    }

    public static <T, R> Bson meta(SFunction<T, ?> fieldName, SFunction<R, ?> metaFieldName) {
        return Projections.meta(fieldName.getFieldNameLine(), metaFieldName.getFieldNameLine());
    }

    public static Bson metaTextScore(String fieldName) {
        return Projections.meta(fieldName, "textScore");
    }

    public static <T> Bson metaTextScore(SFunction<T, ?> fieldName) {
        return Projections.meta(fieldName, "textScore");
    }

    public static Bson metaSearchScore(String fieldName) {
        return Projections.meta(fieldName, "searchScore");
    }

    public static <T> Bson metaSearchScore(SFunction<T, ?> fieldName) {
        return Projections.meta(fieldName, "searchScore");
    }

    public static Bson metaSearchHighlights(String fieldName) {
        return Projections.meta(fieldName, "searchHighlights");
    }

    public static <T> Bson metaSearchHighlights(SFunction<T, ?> fieldName) {
        return Projections.meta(fieldName, "searchHighlights");
    }

    public static Bson slice(String fieldName, int limit) {
        return new BsonDocument(fieldName, (BsonValue)new BsonDocument("$slice", (BsonValue)new BsonInt32(limit)));
    }

    public static <T> Bson slice(SFunction<T, ?> fieldName, int limit) {
        return Projections.slice(fieldName.getFieldNameLine(), limit);
    }

    public static Bson slice(String fieldName, int skip, int limit) {
        return new BsonDocument(fieldName, (BsonValue)new BsonDocument("$slice", (BsonValue)new BsonArray(Arrays.asList(new BsonInt32(skip), new BsonInt32(limit)))));
    }

    public static <T> Bson slice(SFunction<T, ?> fieldName, int skip, int limit) {
        return Projections.slice(fieldName.getFieldNameLine(), skip, limit);
    }

    public static Bson fields(Bson ... projections) {
        return Projections.fields(Arrays.asList(projections));
    }

    public static Bson fields(List<? extends Bson> projections) {
        Assertions.notNull((String)"projections", projections);
        return new FieldsProjection(projections);
    }

    private static Bson combine(List<String> fieldNames, BsonValue value) {
        BsonDocument document = new BsonDocument();
        for (String fieldName : fieldNames) {
            document.remove((Object)fieldName);
            document.append(fieldName, value);
        }
        return document;
    }

    private static class ElemMatchFilterProjection
    implements Bson {
        private final String fieldName;
        private final Bson filter;

        ElemMatchFilterProjection(String fieldName, Bson filter) {
            this.fieldName = fieldName;
            this.filter = filter;
        }

        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry codecRegistry) {
            return new BsonDocument(this.fieldName, (BsonValue)new BsonDocument("$elemMatch", (BsonValue)this.filter.toBsonDocument(documentClass, codecRegistry)));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ElemMatchFilterProjection that = (ElemMatchFilterProjection)o;
            if (!Objects.equals(this.fieldName, that.fieldName)) {
                return false;
            }
            return Objects.equals(this.filter, that.filter);
        }

        public int hashCode() {
            int result = this.fieldName != null ? this.fieldName.hashCode() : 0;
            result = 31 * result + (this.filter != null ? this.filter.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "ElemMatch Projection{fieldName='" + this.fieldName + '\'' + ", filter=" + this.filter + '}';
        }
    }

    private static class FieldsProjection
    implements Bson {
        private final List<? extends Bson> projections;

        FieldsProjection(List<? extends Bson> projections) {
            this.projections = projections;
        }

        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry codecRegistry) {
            BsonDocument combinedDocument = new BsonDocument();
            for (Bson bson : this.projections) {
                BsonDocument sortDocument = bson.toBsonDocument(documentClass, codecRegistry);
                for (String key : sortDocument.keySet()) {
                    combinedDocument.remove((Object)key);
                    combinedDocument.append(key, sortDocument.get((Object)key));
                }
            }
            return combinedDocument;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FieldsProjection that = (FieldsProjection)o;
            return Objects.equals(this.projections, that.projections);
        }

        public int hashCode() {
            return this.projections != null ? this.projections.hashCode() : 0;
        }

        public String toString() {
            return "Projections{projections=" + this.projections + '}';
        }
    }
}

