/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.aggregate.pipeline;

import com.anwen.mongo.aggregate.pipeline.SimpleExpression;
import com.anwen.mongo.support.SFunction;
import com.mongodb.BasicDBObject;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.BsonField;
import com.mongodb.lang.Nullable;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.conversions.Bson;

public final class Accumulators {
    public static <TExpression> BsonField sum(String fieldName, TExpression expression) {
        return Accumulators.accumulatorOperator("$sum", fieldName, expression);
    }

    public static <TExpression, T> BsonField sum(SFunction<T, ?> fieldName, TExpression expression) {
        return Accumulators.sum(fieldName.getFieldNameLine(), expression);
    }

    public static <TExpression> BsonField avg(String fieldName, TExpression expression) {
        return Accumulators.accumulatorOperator("$avg", fieldName, expression);
    }

    public static <TExpression, T> BsonField avg(SFunction<T, ?> fieldName, TExpression expression) {
        return Accumulators.avg(fieldName.getFieldNameLine(), expression);
    }

    public static <TExpression> BsonField first(String fieldName, TExpression expression) {
        return Accumulators.accumulatorOperator("$first", fieldName, expression);
    }

    public static <TExpression, T> BsonField first(SFunction<T, ?> fieldName, TExpression expression) {
        return Accumulators.first(fieldName.getFieldNameLine(), expression);
    }

    public static <InExpression, NExpression> BsonField firstN(String fieldName, NExpression nExpression, InExpression inExpression) {
        return Accumulators.pickNAccumulator((String)Assertions.notNull((String)"fieldName", (Object)fieldName), "$firstN", Assertions.notNull((String)"inExpression", inExpression), Assertions.notNull((String)"nExpression", nExpression));
    }

    public static <InExpression, NExpression, T> BsonField firstN(SFunction<T, ?> fieldName, NExpression nExpression, InExpression inExpression) {
        return Accumulators.firstN(fieldName.getFieldNameLine(), nExpression, inExpression);
    }

    public static <NExpression, T, R> BsonField firstN(SFunction<T, ?> fieldName, NExpression nExpression, SFunction<R, ?> inExpression) {
        return Accumulators.firstN(fieldName.getFieldNameLine(), nExpression, inExpression.getFieldNameLineOption());
    }

    public static <NExpression, T> BsonField firstN(String fieldName, NExpression nExpression, SFunction<T, ?> inExpression) {
        return Accumulators.firstN(fieldName, nExpression, inExpression.getFieldNameLineOption());
    }

    @SafeVarargs
    public static <NExpression, T> BsonField firstN(String fieldName, NExpression nExpression, SFunction<T, ?> ... inExpression) {
        return Accumulators.firstN(fieldName, Arrays.stream(inExpression).map(SFunction::getFieldNameLineOption).collect(Collectors.toList()), nExpression);
    }

    public static <NExpression> BsonField firstN(String fieldName, NExpression nExpression, String ... inExpression) {
        return Accumulators.firstN(fieldName, nExpression, Arrays.stream(inExpression).collect(Collectors.toList()));
    }

    public static <OutExpression> BsonField top(String fieldName, Bson sortBy, OutExpression outExpression) {
        return Accumulators.sortingPickAccumulator((String)Assertions.notNull((String)"fieldName", (Object)fieldName), "$top", (Bson)Assertions.notNull((String)"sortBy", (Object)sortBy), Assertions.notNull((String)"outExpression", outExpression));
    }

    public static <OutExpression, T> BsonField top(SFunction<T, ?> fieldName, Bson sortBy, OutExpression outExpression) {
        return Accumulators.top(fieldName.getFieldNameLine(), sortBy, outExpression);
    }

    @SafeVarargs
    public static <T, R> BsonField top(SFunction<T, ?> fieldName, Bson sortBy, SFunction<R, ?> ... outExpression) {
        return Accumulators.top(fieldName.getFieldNameLine(), sortBy, Arrays.stream(outExpression).map(SFunction::getFieldNameLineOption).collect(Collectors.toList()));
    }

    public static <T> BsonField top(SFunction<T, ?> fieldName, Bson sortBy, String ... outExpression) {
        return Accumulators.top(fieldName.getFieldNameLine(), sortBy, Arrays.stream(outExpression).collect(Collectors.toList()));
    }

    public static <OutExpression, NExpression> BsonField topN(String fieldName, Bson sortBy, NExpression nExpression, OutExpression outExpression) {
        return Accumulators.sortingPickNAccumulator((String)Assertions.notNull((String)"fieldName", (Object)fieldName), "$topN", (Bson)Assertions.notNull((String)"sortBy", (Object)sortBy), Assertions.notNull((String)"outExpression", outExpression), Assertions.notNull((String)"nExpression", nExpression));
    }

    public static <OutExpression, NExpression, T> BsonField topN(SFunction<T, ?> fieldName, Bson sortBy, NExpression nExpression, OutExpression outExpression) {
        return Accumulators.topN(fieldName.getFieldNameLine(), sortBy, nExpression, outExpression);
    }

    public static <NExpression, T, R> BsonField topN(SFunction<T, ?> fieldName, Bson sortBy, NExpression nExpression, SFunction<R, ?> outExpression) {
        return Accumulators.topN(fieldName.getFieldNameLine(), sortBy, nExpression, outExpression);
    }

    @SafeVarargs
    public static <NExpression, T, R> BsonField topN(SFunction<T, ?> fieldName, Bson sortBy, NExpression nExpression, SFunction<R, ?> ... outExpression) {
        return Accumulators.topN(fieldName.getFieldNameLine(), sortBy, nExpression, Arrays.stream(outExpression).map(SFunction::getFieldNameLineOption).collect(Collectors.toList()));
    }

    public static <NExpression, T> BsonField topN(SFunction<T, ?> fieldName, Bson sortBy, NExpression nExpression, String ... outExpression) {
        return Accumulators.topN(fieldName.getFieldNameLine(), sortBy, nExpression, Arrays.stream(outExpression).collect(Collectors.toList()));
    }

    public static <TExpression> BsonField last(String fieldName, TExpression expression) {
        return Accumulators.accumulatorOperator("$last", fieldName, expression);
    }

    public static <T, R> BsonField last(SFunction<T, ?> fieldName, SFunction<R, ?> expression) {
        return Accumulators.last(fieldName.getFieldNameLine(), expression.getFieldNameLineOption());
    }

    public static <TExpression, T> BsonField last(SFunction<T, ?> fieldName, TExpression expression) {
        return Accumulators.last(fieldName.getFieldNameLine(), expression);
    }

    public static <T> BsonField last(String fieldName, SFunction<T, ?> expression) {
        return Accumulators.last(fieldName, expression.getFieldNameLineOption());
    }

    public static <InExpression, NExpression> BsonField lastN(String fieldName, NExpression nExpression, InExpression inExpression) {
        return Accumulators.pickNAccumulator((String)Assertions.notNull((String)"fieldName", (Object)fieldName), "$lastN", Assertions.notNull((String)"inExpression", inExpression), Assertions.notNull((String)"nExpression", nExpression));
    }

    public static <InExpression, NExpression, T> BsonField lastN(SFunction<T, ?> fieldName, NExpression nExpression, InExpression inExpression) {
        return Accumulators.lastN(fieldName.getFieldNameLine(), nExpression, inExpression);
    }

    public static <NExpression, T, R> BsonField lastN(SFunction<T, ?> fieldName, NExpression nExpression, SFunction<R, ?> inExpression) {
        return Accumulators.lastN(fieldName.getFieldNameLine(), nExpression, inExpression.getFieldNameLineOption());
    }

    public static <NExpression, T> BsonField lastN(SFunction<T, ?> fieldName, NExpression nExpression, String ... inExpression) {
        return Accumulators.lastN(fieldName.getFieldNameLine(), nExpression, Arrays.stream(inExpression).collect(Collectors.toList()));
    }

    @SafeVarargs
    public static <NExpression, T, R> BsonField lastN(SFunction<T, ?> fieldName, NExpression nExpression, SFunction<R, ?> ... inExpression) {
        return Accumulators.lastN(fieldName.getFieldNameLine(), nExpression, Arrays.stream(inExpression).map(SFunction::getFieldNameLineOption).collect(Collectors.toList()));
    }

    public static <OutExpression> BsonField bottom(String fieldName, Bson sortBy, OutExpression outExpression) {
        return Accumulators.sortingPickAccumulator((String)Assertions.notNull((String)"fieldName", (Object)fieldName), "$bottom", (Bson)Assertions.notNull((String)"sortBy", (Object)sortBy), Assertions.notNull((String)"outExpression", outExpression));
    }

    public static <OutExpression, T> BsonField bottom(SFunction<T, ?> fieldName, Bson sortBy, OutExpression outExpression) {
        return Accumulators.bottom(fieldName.getFieldNameLine(), sortBy, outExpression);
    }

    public static <T, R> BsonField bottom(SFunction<T, ?> fieldName, Bson sortBy, SFunction<R, ?> outExpression) {
        return Accumulators.bottom(fieldName.getFieldNameLine(), sortBy, outExpression.getFieldNameLineOption());
    }

    @SafeVarargs
    public static <T, R> BsonField bottom(SFunction<T, ?> fieldName, Bson sortBy, SFunction<R, ?> ... outExpression) {
        return Accumulators.bottom(fieldName.getFieldNameLine(), sortBy, Arrays.stream(outExpression).map(SFunction::getFieldNameLineOption).collect(Collectors.toList()));
    }

    public static <T> BsonField bottom(SFunction<T, ?> fieldName, Bson sortBy, String ... outExpression) {
        return Accumulators.bottom(fieldName.getFieldNameLine(), sortBy, Arrays.stream(outExpression).collect(Collectors.toList()));
    }

    public static <OutExpression, NExpression> BsonField bottomN(String fieldName, Bson sortBy, NExpression nExpression, OutExpression outExpression) {
        return Accumulators.sortingPickNAccumulator((String)Assertions.notNull((String)"fieldName", (Object)fieldName), "$bottomN", (Bson)Assertions.notNull((String)"sortBy", (Object)sortBy), Assertions.notNull((String)"outExpression", outExpression), Assertions.notNull((String)"nExpression", nExpression));
    }

    public static <OutExpression, NExpression, T> BsonField bottomN(SFunction<T, ?> fieldName, Bson sortBy, NExpression nExpression, OutExpression outExpression) {
        return Accumulators.bottomN(fieldName.getFieldNameLine(), sortBy, nExpression, outExpression);
    }

    public static <NExpression, T, R> BsonField bottomN(SFunction<T, ?> fieldName, Bson sortBy, NExpression nExpression, SFunction<R, ?> outExpression) {
        return Accumulators.bottomN(fieldName.getFieldNameLine(), sortBy, nExpression, outExpression.getFieldNameLineOption());
    }

    @SafeVarargs
    public static <NExpression, T, R> BsonField bottomN(SFunction<T, ?> fieldName, Bson sortBy, NExpression nExpression, SFunction<R, ?> ... outExpression) {
        return Accumulators.bottomN(fieldName.getFieldNameLine(), sortBy, nExpression, Arrays.stream(outExpression).map(SFunction::getFieldNameLineOption).collect(Collectors.toList()));
    }

    public static <NExpression, T> BsonField bottomN(SFunction<T, ?> fieldName, Bson sortBy, NExpression nExpression, String ... outExpression) {
        return Accumulators.bottomN(fieldName.getFieldNameLine(), sortBy, nExpression, Arrays.stream(outExpression).collect(Collectors.toList()));
    }

    public static <TExpression> BsonField max(String fieldName, TExpression expression) {
        return Accumulators.accumulatorOperator("$max", fieldName, expression);
    }

    public static <TExpression, T> BsonField max(SFunction<T, ?> fieldName, TExpression expression) {
        return Accumulators.max(fieldName.getFieldNameLine(), expression);
    }

    public static <T, R> BsonField max(SFunction<T, ?> fieldName, SFunction<R, ?> expression) {
        return Accumulators.max(fieldName.getFieldNameLine(), expression.getFieldNameLineOption());
    }

    public static <InExpression, NExpression> BsonField maxN(String fieldName, NExpression nExpression, InExpression inExpression) {
        return Accumulators.pickNAccumulator((String)Assertions.notNull((String)"fieldName", (Object)fieldName), "$maxN", Assertions.notNull((String)"inExpression", inExpression), Assertions.notNull((String)"nExpression", nExpression));
    }

    public static <InExpression, NExpression, T> BsonField maxN(SFunction<T, ?> fieldName, NExpression nExpression, InExpression inExpression) {
        return Accumulators.maxN(fieldName.getFieldNameLine(), nExpression, inExpression);
    }

    public static <NExpression, T, R> BsonField maxN(SFunction<T, ?> fieldName, NExpression nExpression, SFunction<R, ?> inExpression) {
        return Accumulators.maxN(fieldName.getFieldNameLine(), nExpression, inExpression.getFieldNameLineOption());
    }

    @SafeVarargs
    public static <NExpression, T, R> BsonField maxN(SFunction<T, ?> fieldName, NExpression nExpression, SFunction<R, ?> ... inExpression) {
        return Accumulators.maxN(fieldName.getFieldNameLine(), nExpression, Arrays.stream(inExpression).map(SFunction::getFieldNameLineOption).collect(Collectors.toList()));
    }

    public static <NExpression, T> BsonField maxN(SFunction<T, ?> fieldName, NExpression nExpression, String ... inExpression) {
        return Accumulators.maxN(fieldName.getFieldNameLine(), nExpression, Arrays.stream(inExpression).collect(Collectors.toList()));
    }

    public static <TExpression> BsonField min(String fieldName, TExpression expression) {
        return Accumulators.accumulatorOperator("$min", fieldName, expression);
    }

    public static <TExpression, T> BsonField min(SFunction<T, ?> fieldName, TExpression expression) {
        return Accumulators.min(fieldName.getFieldNameLine(), expression);
    }

    public static <T, R> BsonField min(SFunction<T, ?> fieldName, SFunction<R, ?> expression) {
        return Accumulators.min(fieldName.getFieldNameLine(), expression.getFieldNameLineOption());
    }

    public static <InExpression, NExpression> BsonField minN(String fieldName, NExpression nExpression, InExpression inExpression) {
        return Accumulators.pickNAccumulator((String)Assertions.notNull((String)"fieldName", (Object)fieldName), "$minN", Assertions.notNull((String)"inExpression", inExpression), Assertions.notNull((String)"nExpression", nExpression));
    }

    public static <InExpression, NExpression, T> BsonField minN(SFunction<T, ?> fieldName, NExpression nExpression, InExpression inExpression) {
        return Accumulators.minN(fieldName.getFieldNameLine(), nExpression, inExpression);
    }

    public static <NExpression, T, R> BsonField minN(SFunction<T, ?> fieldName, NExpression nExpression, SFunction<R, ?> inExpression) {
        return Accumulators.minN(fieldName.getFieldNameLine(), nExpression, inExpression.getFieldNameLineOption());
    }

    @SafeVarargs
    public static <NExpression, T, R> BsonField minN(SFunction<T, ?> fieldName, NExpression nExpression, SFunction<R, ?> ... inExpression) {
        return Accumulators.minN(fieldName.getFieldNameLine(), nExpression, Arrays.stream(inExpression).map(SFunction::getFieldNameLineOption).collect(Collectors.toList()));
    }

    public static <NExpression, T> BsonField minN(SFunction<T, ?> fieldName, NExpression nExpression, String ... inExpression) {
        return Accumulators.minN(fieldName.getFieldNameLine(), nExpression, Arrays.stream(inExpression).collect(Collectors.toList()));
    }

    public static <TExpression> BsonField push(String fieldName, TExpression expression) {
        return Accumulators.accumulatorOperator("$push", fieldName, expression);
    }

    public static <TExpression, T> BsonField push(SFunction<T, ?> fieldName, TExpression expression) {
        return Accumulators.push(fieldName.getFieldNameLine(), expression);
    }

    public static <T, R> BsonField push(SFunction<T, ?> fieldName, SFunction<R, ?> expression) {
        return Accumulators.push(fieldName.getFieldNameLine(), expression.getFieldNameLineOption());
    }

    @SafeVarargs
    public static <T, R> BsonField push(SFunction<T, ?> fieldName, SFunction<R, ?> ... expression) {
        BasicDBObject basicDBObject = new BasicDBObject();
        for (SFunction<R, ?> function : expression) {
            basicDBObject.put((Object)function.getFieldNameLine(), (Object)function.getFieldNameLineOption());
        }
        return Accumulators.push(fieldName.getFieldNameLine(), basicDBObject);
    }

    public static <TExpression> BsonField addToSet(String fieldName, TExpression expression) {
        return Accumulators.accumulatorOperator("$addToSet", fieldName, expression);
    }

    public static <TExpression, T> BsonField addToSet(SFunction<T, ?> fieldName, TExpression expression) {
        return Accumulators.addToSet(fieldName.getFieldNameLine(), expression);
    }

    public static <T, R> BsonField addToSet(SFunction<T, ?> fieldName, SFunction<R, ?> expression) {
        return Accumulators.addToSet(fieldName.getFieldNameLine(), expression.getFieldNameLineOption());
    }

    public static <TExpression> BsonField mergeObjects(String fieldName, TExpression expression) {
        return Accumulators.accumulatorOperator("$mergeObjects", fieldName, expression);
    }

    public static <TExpression, T> BsonField mergeObjects(SFunction<T, ?> fieldName, TExpression expression) {
        return Accumulators.mergeObjects(fieldName.getFieldNameLine(), expression);
    }

    public static <T, R> BsonField mergeObjects(SFunction<T, ?> fieldName, SFunction<R, ?> expression) {
        return Accumulators.mergeObjects(fieldName.getFieldNameLine(), expression.getFieldNameLineOption());
    }

    public static <TExpression> BsonField stdDevPop(String fieldName, TExpression expression) {
        return Accumulators.accumulatorOperator("$stdDevPop", fieldName, expression);
    }

    public static <TExpression, T> BsonField stdDevPop(SFunction<T, ?> fieldName, TExpression expression) {
        return Accumulators.stdDevPop(fieldName.getFieldNameLine(), expression);
    }

    public static <T, R> BsonField stdDevPop(SFunction<T, ?> fieldName, SFunction<R, ?> expression) {
        return Accumulators.stdDevPop(fieldName.getFieldNameLine(), expression.getFieldNameLineOption());
    }

    public static <TExpression> BsonField stdDevSamp(String fieldName, TExpression expression) {
        return Accumulators.accumulatorOperator("$stdDevSamp", fieldName, expression);
    }

    public static <TExpression, T> BsonField stdDevSamp(SFunction<T, ?> fieldName, TExpression expression) {
        return Accumulators.stdDevSamp(fieldName.getFieldNameLine(), expression);
    }

    public static <T, R> BsonField stdDevSamp(SFunction<T, ?> fieldName, SFunction<R, ?> expression) {
        return Accumulators.stdDevSamp(fieldName.getFieldNameLine(), expression.getFieldNameLineOption());
    }

    public static BsonField accumulator(String fieldName, String initFunction, String accumulateFunction, String mergeFunction) {
        return Accumulators.accumulator(fieldName, initFunction, null, accumulateFunction, null, mergeFunction, null, "js");
    }

    public static <T> BsonField accumulator(SFunction<T, ?> fieldName, String initFunction, String accumulateFunction, String mergeFunction) {
        return Accumulators.accumulator(fieldName.getFieldNameLine(), initFunction, accumulateFunction, mergeFunction);
    }

    public static BsonField accumulator(String fieldName, String initFunction, String accumulateFunction, String mergeFunction, @Nullable String finalizeFunction) {
        return Accumulators.accumulator(fieldName, initFunction, null, accumulateFunction, null, mergeFunction, finalizeFunction, "js");
    }

    public static <T> BsonField accumulator(SFunction<T, ?> fieldName, String initFunction, String accumulateFunction, String mergeFunction, @Nullable String finalizeFunction) {
        return Accumulators.accumulator(fieldName.getFieldNameLine(), initFunction, accumulateFunction, mergeFunction, finalizeFunction);
    }

    public static BsonField accumulator(String fieldName, String initFunction, @Nullable List<String> initArgs, String accumulateFunction, @Nullable List<String> accumulateArgs, String mergeFunction, @Nullable String finalizeFunction) {
        return Accumulators.accumulator(fieldName, initFunction, initArgs, accumulateFunction, accumulateArgs, mergeFunction, finalizeFunction, "js");
    }

    public static <T> BsonField accumulator(SFunction<T, ?> fieldName, String initFunction, @Nullable List<String> initArgs, String accumulateFunction, @Nullable List<String> accumulateArgs, String mergeFunction, @Nullable String finalizeFunction) {
        return Accumulators.accumulator(fieldName.getFieldNameLine(), initFunction, initArgs, accumulateFunction, accumulateArgs, mergeFunction, finalizeFunction);
    }

    public static BsonField accumulator(String fieldName, String initFunction, String accumulateFunction, String mergeFunction, @Nullable String finalizeFunction, String lang) {
        return Accumulators.accumulator(fieldName, initFunction, null, accumulateFunction, null, mergeFunction, finalizeFunction, lang);
    }

    public static <T> BsonField accumulator(SFunction<T, ?> fieldName, String initFunction, String accumulateFunction, String mergeFunction, @Nullable String finalizeFunction, String lang) {
        return Accumulators.accumulator(fieldName.getFieldNameLine(), initFunction, null, accumulateFunction, null, mergeFunction, finalizeFunction, lang);
    }

    public static BsonField accumulator(String fieldName, String initFunction, @Nullable List<String> initArgs, String accumulateFunction, @Nullable List<String> accumulateArgs, String mergeFunction, @Nullable String finalizeFunction, String lang) {
        BsonDocument accumulatorStage = new BsonDocument("init", (BsonValue)new BsonString(initFunction)).append("initArgs", (BsonValue)(initArgs != null ? new BsonArray(initArgs.stream().map(BsonString::new).collect(Collectors.toList())) : new BsonArray())).append("accumulate", (BsonValue)new BsonString(accumulateFunction)).append("accumulateArgs", (BsonValue)(accumulateArgs != null ? new BsonArray(accumulateArgs.stream().map(BsonString::new).collect(Collectors.toList())) : new BsonArray())).append("merge", (BsonValue)new BsonString(mergeFunction)).append("lang", (BsonValue)new BsonString(lang));
        if (finalizeFunction != null) {
            accumulatorStage.append("finalize", (BsonValue)new BsonString(finalizeFunction));
        }
        return Accumulators.accumulatorOperator("$accumulator", fieldName, accumulatorStage);
    }

    public static <T> BsonField accumulator(SFunction<T, ?> fieldName, String initFunction, @Nullable List<String> initArgs, String accumulateFunction, @Nullable List<String> accumulateArgs, String mergeFunction, @Nullable String finalizeFunction, String lang) {
        return Accumulators.accumulator(fieldName.getFieldNameLine(), initFunction, initArgs, accumulateFunction, accumulateArgs, mergeFunction, finalizeFunction, lang);
    }

    private static <TExpression> BsonField accumulatorOperator(String name, String fieldName, TExpression expression) {
        return new BsonField(fieldName, new SimpleExpression<TExpression>(name, expression));
    }

    private static <InExpression, NExpression> BsonField pickNAccumulator(String fieldName, String accumulatorName, InExpression inExpression, NExpression nExpression) {
        return new BsonField(fieldName, (Bson)new Document(accumulatorName, (Object)new Document("input", inExpression).append("n", nExpression)));
    }

    private static <OutExpression> BsonField sortingPickAccumulator(String fieldName, String accumulatorName, Bson sort, OutExpression outExpression) {
        return new BsonField(fieldName, (Bson)new Document(accumulatorName, (Object)new Document("sortBy", (Object)sort).append("output", outExpression)));
    }

    private static <OutExpression, NExpression> BsonField sortingPickNAccumulator(String fieldName, String accumulatorName, Bson sort, OutExpression outExpression, NExpression nExpression) {
        return new BsonField(fieldName, (Bson)new Document(accumulatorName, (Object)new Document("sortBy", (Object)sort).append("output", outExpression).append("n", nExpression)));
    }

    private Accumulators() {
    }
}

