/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.transactional;

import com.anwen.mongo.annotation.transactional.MongoTransactional;
import com.anwen.mongo.manager.MongoTransactionalManager;
import com.anwen.mongo.toolkit.ArrayUtils;
import com.anwen.mongo.toolkit.ClassTypeUtil;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.core.annotation.Order;

@Aspect
@Order(value=1)
public class MongoTransactionalAspect {
    @Pointcut(value="@annotation(com.anwen.mongo.annotation.transactional.MongoTransactional)")
    private void markMongoTransactional() {
    }

    @Around(value="markMongoTransactional() && @annotation(mongoTransactional)")
    public Object manageTransaction(ProceedingJoinPoint joinPoint, MongoTransactional mongoTransactional) throws Throwable {
        MongoTransactionalManager.startTransaction((MongoTransactional)mongoTransactional);
        try {
            Object result = joinPoint.proceed();
            MongoTransactionalManager.commitTransaction();
            Object object = result;
            return object;
        }
        catch (Exception e) {
            this.handleTransactionException(mongoTransactional, e);
            throw e;
        }
        finally {
            MongoTransactionalManager.closeSession();
        }
    }

    private void handleTransactionException(MongoTransactional mongoTransactional, Exception e) {
        boolean finished;
        Class<?> eClass = e.getClass();
        boolean bl = finished = this.processRollback(mongoTransactional, eClass, true) || this.processRollback(mongoTransactional, eClass, false);
        if (!finished) {
            MongoTransactionalManager.rollbackTransaction();
        }
    }

    private boolean processRollback(MongoTransactional mongoTransactional, Class<? extends Exception> eClass, boolean isRollback) {
        Object[] exceptionList;
        Object[] objectArray = exceptionList = isRollback ? mongoTransactional.rollbackFor() : mongoTransactional.noRollbackFor();
        if (ArrayUtils.isEmpty((Object[])exceptionList)) {
            return false;
        }
        for (Object exceptionType : exceptionList) {
            if (!ClassTypeUtil.isTargetClass((Class)exceptionType, eClass).booleanValue()) continue;
            if (isRollback) {
                MongoTransactionalManager.rollbackTransaction();
            } else {
                MongoTransactionalManager.commitTransaction();
            }
            return true;
        }
        return false;
    }
}

