/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.transactional;

import com.anwen.mongo.logging.Log;
import com.anwen.mongo.logging.LogFactory;
import com.anwen.mongo.manager.MongoTransactionalManager;
import com.mongodb.TransactionOptions;
import com.mongodb.client.ClientSession;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;

public class MongoPlusTransactionalManager
extends AbstractPlatformTransactionManager {
    Log log = LogFactory.getLog(MongoPlusTransactionalManager.class);
    private final TransactionOptions options;

    public MongoPlusTransactionalManager(TransactionOptions options) {
        this.options = options;
    }

    protected Object doGetTransaction() throws TransactionException {
        return MongoTransactionalManager.getTransaction();
    }

    protected void doBegin(Object transaction, TransactionDefinition definition) throws TransactionException {
        ClientSession clientSession = (ClientSession)transaction;
        MongoTransactionalManager.startTransaction((TransactionOptions)this.options);
        if (this.log.isDebugEnabled()) {
            this.log.debug("begin transaction -> name: {} , sessionId: {}", (Object)definition.getName(), (Object)clientSession.getServerSession().getIdentifier());
        }
    }

    protected void doCommit(DefaultTransactionStatus status) throws TransactionException {
        ClientSession clientSession = (ClientSession)status.getTransaction();
        MongoTransactionalManager.commitTransaction();
        if (this.log.isDebugEnabled()) {
            this.log.debug("commit transaction -> sessionId: {}", (Object)clientSession.getServerSession().getIdentifier());
        }
    }

    protected void doRollback(DefaultTransactionStatus status) throws TransactionException {
        ClientSession clientSession = (ClientSession)status.getTransaction();
        MongoTransactionalManager.rollbackTransaction();
        if (this.log.isDebugEnabled()) {
            this.log.debug("rollback transaction");
        }
    }

    protected void doCleanupAfterCompletion(Object transaction) {
        MongoTransactionalManager.closeSession();
    }
}

