/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.logic;

import com.anwen.mongo.annotation.logice.IgnoreLogic;
import com.anwen.mongo.cache.global.CollectionLogicDeleteCache;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.core.annotation.Order;

@Aspect
@Order(value=0)
public class MongoLogicIgnoreAspect {
    @Pointcut(value="@annotation(com.anwen.mongo.annotation.logice.IgnoreLogic)")
    private void markIgnoreLogic() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="markIgnoreLogic() && @annotation(ignoreLogic)")
    public Object ignoreLogic(ProceedingJoinPoint joinPoint, IgnoreLogic ignoreLogic) throws Throwable {
        try {
            CollectionLogicDeleteCache.setLogicIgnore((boolean)true);
            Object object = joinPoint.proceed();
            return object;
        }
        finally {
            CollectionLogicDeleteCache.clear();
        }
    }
}

