/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.config;

import com.anwen.mongo.property.MongoDBConnectProperty;
import com.anwen.mongo.toolkit.StringUtils;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.springframework.boot.autoconfigure.mongo.MongoProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MongoPropertyConfiguration {
    private final MongoDBConnectProperty mongoDBConnectProperty;
    private final MongoProperties mongoProperties;

    public MongoPropertyConfiguration(MongoDBConnectProperty mongoDBConnectProperty, MongoProperties mongoProperties) {
        this.mongoDBConnectProperty = mongoDBConnectProperty;
        this.mongoProperties = mongoProperties;
        this.init();
    }

    public void init() {
        if (StringUtils.isNotBlank((String)this.mongoDBConnectProperty.getUrl())) {
            this.mongoProperties.setUri(this.mongoDBConnectProperty.getUrl());
        } else {
            this.mongoProperties.setHost((String)Arrays.stream(this.mongoDBConnectProperty.getHost().split(",")).collect(Collectors.toList()).get(0));
            this.mongoProperties.setPort(Integer.valueOf((String)Arrays.stream(this.mongoDBConnectProperty.getPort().split(",")).collect(Collectors.toList()).get(0)));
            if (StringUtils.isNotBlank((String)this.mongoDBConnectProperty.getUsername())) {
                this.mongoProperties.setUsername(this.mongoDBConnectProperty.getUsername());
            }
            if (StringUtils.isNotBlank((String)this.mongoDBConnectProperty.getPassword())) {
                this.mongoProperties.setPassword(this.mongoDBConnectProperty.getPassword().toCharArray());
            }
            this.mongoProperties.setAuthenticationDatabase(this.mongoDBConnectProperty.getAuthenticationDatabase());
        }
        this.mongoProperties.setDatabase((String)Arrays.stream(this.mongoDBConnectProperty.getDatabase().split(",")).collect(Collectors.toList()).get(0));
    }
}

