/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.config;

import com.anwen.mongo.cache.global.DataSourceNameCache;
import com.anwen.mongo.cache.global.MongoPlusClientCache;
import com.anwen.mongo.cache.global.SimpleCache;
import com.anwen.mongo.config.Configuration;
import com.anwen.mongo.conn.CollectionManager;
import com.anwen.mongo.datasource.MongoDataSourceAspect;
import com.anwen.mongo.factory.MongoClientFactory;
import com.anwen.mongo.logic.MongoLogicIgnoreAspect;
import com.anwen.mongo.manager.DataSourceManager;
import com.anwen.mongo.manager.MongoPlusClient;
import com.anwen.mongo.mapper.BaseMapper;
import com.anwen.mongo.mapper.DefaultBaseMapperImpl;
import com.anwen.mongo.mapping.MappingMongoConverter;
import com.anwen.mongo.mapping.MongoConverter;
import com.anwen.mongo.mapping.SimpleTypeHolder;
import com.anwen.mongo.model.BaseProperty;
import com.anwen.mongo.property.MongoDBCollectionProperty;
import com.anwen.mongo.property.MongoDBConfigurationProperty;
import com.anwen.mongo.property.MongoDBConnectProperty;
import com.anwen.mongo.property.MongoDBLogProperty;
import com.anwen.mongo.tenant.TenantAspect;
import com.anwen.mongo.toolkit.CollUtil;
import com.anwen.mongo.toolkit.MongoUtil;
import com.anwen.mongo.transactional.MongoTransactionalAspect;
import com.mongodb.TransactionOptions;
import com.mongodb.client.MongoClient;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@EnableConfigurationProperties(value={MongoDBConnectProperty.class, MongoDBCollectionProperty.class, MongoDBConfigurationProperty.class, MongoDBLogProperty.class})
public class MongoPlusConfiguration {
    private final MongoDBConnectProperty mongoDBConnectProperty;
    private final MongoDBConfigurationProperty mongoDBConfigurationProperty;
    protected final MongoDBLogProperty mongoDBLogProperty;

    public MongoPlusConfiguration(MongoDBConnectProperty mongodbConnectProperty, MongoDBConfigurationProperty mongodbConfigurationProperty, MongoDBLogProperty mongoDBLogProperty) {
        this.mongoDBConnectProperty = mongodbConnectProperty;
        this.mongoDBConfigurationProperty = mongodbConfigurationProperty;
        this.mongoDBLogProperty = mongoDBLogProperty;
    }

    @Bean
    @ConditionalOnMissingBean
    public MongoClientFactory mongoClientFactory() {
        MongoClientFactory mongoClientFactory = MongoClientFactory.getInstance((MongoClient)MongoUtil.getMongo((String)"master", (BaseProperty)this.mongoDBConnectProperty));
        if (CollUtil.isNotEmpty(this.mongoDBConnectProperty.getSlaveDataSource())) {
            this.mongoDBConnectProperty.getSlaveDataSource().forEach(slaveDataSource -> mongoClientFactory.addMongoClient(slaveDataSource.getSlaveName(), MongoUtil.getMongo((String)slaveDataSource.getSlaveName(), (BaseProperty)slaveDataSource)));
        }
        return mongoClientFactory;
    }

    @Bean
    @ConditionalOnMissingBean
    public MongoClient mongo(MongoClientFactory mongoClientFactory) {
        return mongoClientFactory.getMongoClient();
    }

    @Bean
    @ConditionalOnMissingBean(value={MongoPlusClient.class})
    public MongoPlusClient mongoPlusClient(MongoClient mongo, MongoClientFactory mongoClientFactory) {
        MongoPlusClient mongoPlusClient = Configuration.builder().initMongoPlusClient(mongo, (BaseProperty)this.mongoDBConnectProperty);
        mongoClientFactory.getMongoClientMap().forEach((ds, mongoClient) -> {
            Map cfr_ignored_0 = mongoPlusClient.getCollectionManagerMap().put(ds, new LinkedHashMap<String, CollectionManager>(){
                {
                    String database = DataSourceNameCache.getBaseProperty((String)ds).getDatabase();
                    Arrays.stream(database.split(",")).collect(Collectors.toList()).forEach((? super T db) -> this.put(db, new CollectionManager(db)));
                }
            });
        });
        MongoPlusClientCache.mongoPlusClient = mongoPlusClient;
        if (this.mongoDBConfigurationProperty.getBanner().booleanValue()) {
            if (this.mongoDBConfigurationProperty.getIkun().booleanValue()) {
                System.out.println("                 \u9e21\u4f60\u592a\u7f8e\n               \u9e21\u4f60\u5b9e\u5728\u592a\u7f8e\n                \u9e21\u4f60\u662f\u592a\u7f8e\n                 \u9e21\u4f60\u592a\u7f8e\n              \u5b9e\u5728\u662f\u592a\u7f8e\u9e21\u4f60\n         \u9e21\u4f60 \u5b9e\u5728\u662f\u592a\u7f8e\u9e21\u4f60 \u7f8e\n       \u9e21\u4f60  \u5b9e\u5728\u662f\u592a\u7f8e\u9e21\u7f8e   \u592a\u7f8e\n      \u9e21\u4f60  \u5b9e\u5728\u662f\u592a\u7f8e\u9e21\u7f8e      \u592a\u7f8e\n    \u9e21\u4f60    \u5b9e\u5728\u662f\u592a\u7f8e\u9e21\u7f8e       \u592a\u7f8e\n   \u9e21\u4f60    \u9e21\u4f60\u5b9e\u5728\u662f\u7f8e\u592a\u7f8e    \u7f8e\u84dd\u7403\u7403\u7403\n\u9e21 \u9e21     \u9e21\u4f60\u5b9e\u5728\u662f\u592a\u7f8e     \u7bee\u7403\u7bee\u7403\u7403\u7403\u7403\n \u9e21      \u9e21\u4f60\u592a\u7f8e\u88c6\u9e21\u592a\u554a     \u7403\u7403\u84dd\u7bee\u7403\u7403\n         \u9e21\u4f60\u592a\u7f8e\u88c6\u88c6\u9e21\u7f8e       \u7403\u7403\u7403\n          \u9e21\u4f60\u88c6\u5c0f j \u9e21\u592a\u7f8e\n           \u9e21\u592a\u7f8e    \u9e21\u592a\u7f8e\n            \u9e21\u7f8e      \u9e21\u7f8e\n            \u9e21\u7f8e       \u9e21\u7f8e\n             \u9e21\u7f8e       \u9e21\u7f8e\n             \u9e21\u592a       \u9e21\u592a\n           \u9e21 \u811a       \u9e21 \u811a\n           \u76ae \u978b       \u76ae \u978b\n       \u91d1\u5149 \u5927\u9053         \u91d1\u5149 \u5927\u9053\n      \u9e21\u795e\u4fdd\u4f51       \u6c38\u4e0d\u5b95\u673a     \u6c38\u65e0BUG");
            } else {
                System.out.println("___  ___                       ______ _           \n|  \\/  |                       | ___ \\ |          \n| .  . | ___  _ __   __ _  ___ | |_/ / |_   _ ___ \n| |\\/| |/ _ \\| '_ \\ / _` |/ _ \\|  __/| | | | / __|\n| |  | | (_) | | | | (_| | (_) | |   | | |_| \\__ \\\n\\_|  |_/\\___/|_| |_|\\__, |\\___/\\_|   |_|\\__,_|___/\n                     __/ |                        \n                    |___/                         ");
            }
            System.out.println(":: MongoPlus ::                        (v2.1.3)");
        }
        return mongoPlusClient;
    }

    @Bean
    @ConditionalOnMissingBean(value={SimpleTypeHolder.class})
    public SimpleTypeHolder simpleTypeHolder() {
        SimpleTypeHolder simpleTypeHolder = new SimpleTypeHolder();
        SimpleCache.setSimpleTypeHolder((SimpleTypeHolder)simpleTypeHolder);
        return simpleTypeHolder;
    }

    @Bean
    @ConditionalOnMissingBean(value={MongoConverter.class})
    public MongoConverter mongoConverter(MongoPlusClient mongoPlusClient) {
        return new MappingMongoConverter(mongoPlusClient);
    }

    @Bean
    @ConditionalOnMissingBean(value={BaseMapper.class})
    public BaseMapper mongoBaseMapper(MongoPlusClient mongoPlusClient, MongoConverter mongoConverter) {
        return new DefaultBaseMapperImpl(mongoPlusClient, mongoConverter);
    }

    @Bean(value={"mongoTransactionalAspect"})
    @ConditionalOnMissingBean
    public MongoTransactionalAspect mongoTransactionalAspect() {
        return new MongoTransactionalAspect();
    }

    @Bean(value={"transactionOptions"})
    @ConditionalOnMissingBean
    public TransactionOptions transactionOptions() {
        return TransactionOptions.builder().build();
    }

    @Bean(value={"mongoDataSourceAspect"})
    @ConditionalOnMissingBean
    public MongoDataSourceAspect mongoDataSourceAspect() {
        return new MongoDataSourceAspect();
    }

    @Bean(value={"mongoLogicIgnoreAspect"})
    @ConditionalOnMissingBean
    public MongoLogicIgnoreAspect mongoLogicIgnoreAspect() {
        return new MongoLogicIgnoreAspect();
    }

    @Bean(value={"tenantAspect"})
    @ConditionalOnMissingBean
    public TenantAspect tenantAspect() {
        return new TenantAspect();
    }

    @Bean(value={"dataSourceManager"})
    @ConditionalOnMissingBean
    public DataSourceManager dataSourceManager(MongoPlusClient mongoPlusClient, MongoClientFactory mongoClientFactory) {
        return new DataSourceManager(mongoPlusClient, mongoClientFactory);
    }
}

