/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.config;

import com.anwen.mongo.aware.Aware;
import com.anwen.mongo.cache.global.ConversionCache;
import com.anwen.mongo.cache.global.ExecutorReplacerCache;
import com.anwen.mongo.cache.global.HandlerCache;
import com.anwen.mongo.cache.global.InterceptorCache;
import com.anwen.mongo.cache.global.ListenerCache;
import com.anwen.mongo.cache.global.MappingCache;
import com.anwen.mongo.config.Configuration;
import com.anwen.mongo.domain.MongoPlusConvertException;
import com.anwen.mongo.enums.CollectionNameConvertEnum;
import com.anwen.mongo.handlers.CollectionNameHandler;
import com.anwen.mongo.handlers.MetaObjectHandler;
import com.anwen.mongo.handlers.TenantHandler;
import com.anwen.mongo.handlers.collection.AnnotationOperate;
import com.anwen.mongo.incrementer.IdentifierGenerator;
import com.anwen.mongo.incrementer.id.IdWorker;
import com.anwen.mongo.interceptor.Interceptor;
import com.anwen.mongo.interceptor.business.DynamicCollectionNameInterceptor;
import com.anwen.mongo.interceptor.business.TenantInterceptor;
import com.anwen.mongo.listener.Listener;
import com.anwen.mongo.listener.business.BlockAttackInnerListener;
import com.anwen.mongo.listener.business.LogListener;
import com.anwen.mongo.logging.Log;
import com.anwen.mongo.logging.LogFactory;
import com.anwen.mongo.logic.LogicNamespaceAware;
import com.anwen.mongo.mapper.BaseMapper;
import com.anwen.mongo.model.LogicProperty;
import com.anwen.mongo.property.MongoDBCollectionProperty;
import com.anwen.mongo.property.MongoDBLogProperty;
import com.anwen.mongo.property.MongoLogicDelProperty;
import com.anwen.mongo.replacer.Replacer;
import com.anwen.mongo.service.IService;
import com.anwen.mongo.service.impl.ServiceImpl;
import com.anwen.mongo.strategy.conversion.ConversionStrategy;
import com.anwen.mongo.strategy.mapping.MappingStrategy;
import com.anwen.mongo.toolkit.CollUtil;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;

public class MongoPlusAutoConfiguration
implements InitializingBean {
    private final ApplicationContext applicationContext;
    private final MongoDBLogProperty mongodbLogProperty;
    private final MongoDBCollectionProperty mongodbCollectionProperty;
    private final MongoLogicDelProperty mongoLogicDelProperty;
    private final BaseMapper baseMapper;
    Log log = LogFactory.getLog(MongoPlusAutoConfiguration.class);

    public MongoPlusAutoConfiguration(MongoDBLogProperty mongodbLogProperty, MongoDBCollectionProperty mongodbCollectionProperty, MongoLogicDelProperty mongoLogicDelProperty, BaseMapper baseMapper, ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        this.mongodbLogProperty = mongodbLogProperty;
        this.mongodbCollectionProperty = mongodbCollectionProperty;
        this.mongoLogicDelProperty = mongoLogicDelProperty;
        this.baseMapper = baseMapper;
        this.setConversion();
        this.setMetaObjectHandler();
        this.setListener();
        this.setInterceptor();
        this.setReplacer();
        this.setMapping();
        this.setIdGenerator();
        this.setTenantHandler();
        this.setDynamicCollectionHandler();
        this.setAware(applicationContext);
        this.collectionNameConvert();
    }

    public void afterPropertiesSet() {
        Collection values = this.applicationContext.getBeansOfType(IService.class).values();
        values.forEach(s -> this.setExecute((ServiceImpl)s, s.getGenericityClass()));
        this.setLogicFiled((Class[])values.stream().map(IService::getGenericityClass).toArray(Class[]::new));
    }

    public void setAware(ApplicationContext applicationContext) {
        Configuration builder = Configuration.builder();
        builder.aware((Aware)new LogicNamespaceAware());
        for (Aware aware : applicationContext.getBeansOfType(Aware.class).values()) {
            builder.aware(aware);
        }
    }

    private void setLogicFiled(Class<?> ... collectionClasses) {
        Configuration.builder().logic((LogicProperty)this.mongoLogicDelProperty).setLogicFiled((Class[])collectionClasses);
    }

    private void setExecute(ServiceImpl<?> serviceImpl, Class<?> clazz) {
        serviceImpl.setClazz(clazz);
        serviceImpl.setBaseMapper(this.baseMapper);
    }

    private void setConversion() {
        this.applicationContext.getBeansOfType(ConversionStrategy.class).values().forEach(conversionStrategy -> {
            try {
                Type[] genericInterfaces;
                if (conversionStrategy.getClass().isInterface()) {
                    ConversionCache.putConversionStrategy(conversionStrategy.getClass(), (ConversionStrategy)conversionStrategy);
                    return;
                }
                for (Type anInterface : genericInterfaces = conversionStrategy.getClass().getGenericInterfaces()) {
                    ParameterizedType parameterizedType = (ParameterizedType)anInterface;
                    if (!parameterizedType.getRawType().equals(ConversionStrategy.class)) continue;
                    Class clazz = (Class)parameterizedType.getActualTypeArguments()[0];
                    ConversionCache.putConversionStrategy((Class)clazz, (ConversionStrategy)conversionStrategy);
                    break;
                }
            }
            catch (Exception e) {
                this.log.error("Unknown converter type", (Throwable)e);
                throw new MongoPlusConvertException("Unknown converter type");
            }
        });
    }

    private void setMetaObjectHandler() {
        this.applicationContext.getBeansOfType(MetaObjectHandler.class).values().forEach(metaObjectHandler -> {
            HandlerCache.metaObjectHandler = metaObjectHandler;
        });
    }

    private void setListener() {
        Collection listenerCollection;
        List listeners = ListenerCache.listeners;
        if (this.mongodbLogProperty.getLog().booleanValue()) {
            listeners.add(new LogListener(this.mongodbLogProperty.getPretty().booleanValue()));
        }
        if (this.mongodbCollectionProperty.getBlockAttackInner().booleanValue()) {
            listeners.add(new BlockAttackInnerListener());
        }
        if (CollUtil.isNotEmpty(listenerCollection = this.applicationContext.getBeansOfType(Listener.class).values())) {
            listeners.addAll(listenerCollection);
        }
        ListenerCache.sorted();
    }

    private void setInterceptor() {
        Collection interceptorCollection = this.applicationContext.getBeansOfType(Interceptor.class).values();
        if (CollUtil.isNotEmpty(interceptorCollection)) {
            interceptorCollection = interceptorCollection.stream().sorted(Comparator.comparing(Interceptor::order)).collect(Collectors.toList());
        }
        InterceptorCache.interceptors = new ArrayList(interceptorCollection);
    }

    private void setReplacer() {
        Collection replacers = this.applicationContext.getBeansOfType(Replacer.class).values();
        if (CollUtil.isNotEmpty(replacers)) {
            replacers = replacers.stream().sorted(Comparator.comparing(Replacer::order)).collect(Collectors.toList());
        }
        ExecutorReplacerCache.replacers = new ArrayList(replacers);
    }

    private void setMapping() {
        this.applicationContext.getBeansOfType(MappingStrategy.class).values().forEach(mappingStrategy -> {
            try {
                Type[] genericInterfaces;
                if (mappingStrategy.getClass().isInterface()) {
                    MappingCache.putMappingStrategy(mappingStrategy.getClass(), (MappingStrategy)mappingStrategy);
                    return;
                }
                for (Type anInterface : genericInterfaces = mappingStrategy.getClass().getGenericInterfaces()) {
                    ParameterizedType parameterizedType = (ParameterizedType)anInterface;
                    if (!parameterizedType.getRawType().equals(MappingStrategy.class)) continue;
                    Class clazz = (Class)parameterizedType.getActualTypeArguments()[0];
                    MappingCache.putMappingStrategy((Class)clazz, (MappingStrategy)mappingStrategy);
                    break;
                }
            }
            catch (Exception e) {
                this.log.error("Unknown Mapping type", (Throwable)e);
                throw new MongoPlusConvertException("Unknown converter type");
            }
        });
    }

    private void setIdGenerator() {
        try {
            IdWorker.setIdentifierGenerator((IdentifierGenerator)((IdentifierGenerator)this.applicationContext.getBean(IdentifierGenerator.class)));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setTenantHandler() {
        TenantHandler tenantHandler = null;
        try {
            tenantHandler = (TenantHandler)this.applicationContext.getBean(TenantHandler.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tenantHandler != null) {
            InterceptorCache.interceptors.add(new TenantInterceptor(tenantHandler));
        }
    }

    private void setDynamicCollectionHandler() {
        CollectionNameHandler collectionNameHandler = null;
        try {
            collectionNameHandler = (CollectionNameHandler)this.applicationContext.getBean(CollectionNameHandler.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (collectionNameHandler != null) {
            InterceptorCache.interceptors.add(new DynamicCollectionNameInterceptor(collectionNameHandler, this.baseMapper.getMongoPlusClient()));
        }
    }

    public void collectionNameConvert() {
        AnnotationOperate.setCollectionNameConvertEnum((CollectionNameConvertEnum)this.mongodbCollectionProperty.getMappingStrategy());
    }
}

