/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.annotation;

import com.anwen.mongo.handlers.collection.AnnotationHandler;
import com.anwen.mongo.toolkit.StringUtils;
import java.util.function.Function;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class SpelAnnotationHandler
implements AnnotationHandler {
    public static final ParameterNameDiscoverer PARAMETER_NAME_DISCOVERER = new DefaultParameterNameDiscoverer();
    public static final ExpressionParser EXPRESSION_PARSER = new SpelExpressionParser();
    public final ApplicationContext applicationContext;

    public SpelAnnotationHandler(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public <T, R> R getProperty(T obj, Function<? super T, ? extends R> func) {
        String value;
        Object apply = func.apply(obj);
        if (apply instanceof String && StringUtils.isNotBlank((String)(value = (String)apply)) && value.contains("#")) {
            StandardEvaluationContext context = new StandardEvaluationContext();
            context.setBeanResolver((BeanResolver)new BeanFactoryResolver((BeanFactory)this.applicationContext));
            apply = EXPRESSION_PARSER.parseExpression(value).getValue((EvaluationContext)context, String.class);
        }
        return apply;
    }
}

