/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.tc.txmsg;

import com.codingapi.txlcn.common.util.Transactions;
import com.codingapi.txlcn.txmsg.dto.MessageDto;
import com.codingapi.txlcn.txmsg.params.AskTransactionStateParams;
import com.codingapi.txlcn.txmsg.params.DTXLockParams;
import com.codingapi.txlcn.txmsg.params.InitClientParams;
import com.codingapi.txlcn.txmsg.params.JoinGroupParams;
import com.codingapi.txlcn.txmsg.params.NotifyGroupParams;
import com.codingapi.txlcn.txmsg.params.TxExceptionParams;
import java.io.Serializable;
import java.util.Set;

public class MessageCreator {
    public static MessageDto createGroup(String groupId) {
        MessageDto msg = new MessageDto();
        msg.setGroupId(groupId);
        msg.setAction("createGroup");
        return msg;
    }

    public static MessageDto joinGroup(JoinGroupParams joinGroupParams) {
        MessageDto msg = new MessageDto();
        msg.setGroupId(joinGroupParams.getGroupId());
        msg.setAction("joinGroup");
        msg.setData((Serializable)joinGroupParams);
        return msg;
    }

    public static MessageDto notifyGroup(NotifyGroupParams notifyGroupParams) {
        MessageDto msg = new MessageDto();
        msg.setGroupId(notifyGroupParams.getGroupId());
        msg.setAction("notifyGroup");
        msg.setData((Serializable)notifyGroupParams);
        return msg;
    }

    public static MessageDto acquireLocks(String groupId, Set<String> locks, int lockType) {
        DTXLockParams dtxLockParams = new DTXLockParams();
        dtxLockParams.setGroupId(groupId);
        dtxLockParams.setContextId(Transactions.APPLICATION_ID_WHEN_RUNNING);
        dtxLockParams.setLocks(locks);
        dtxLockParams.setLockType(lockType);
        MessageDto messageDto = new MessageDto();
        messageDto.setAction("qdtxl");
        messageDto.setData((Serializable)dtxLockParams);
        return messageDto;
    }

    public static MessageDto releaseLocks(Set<String> locks) {
        DTXLockParams dtxLockParams = new DTXLockParams();
        dtxLockParams.setContextId(Transactions.APPLICATION_ID_WHEN_RUNNING);
        dtxLockParams.setLocks(locks);
        MessageDto messageDto = new MessageDto();
        messageDto.setAction("rdtxl");
        messageDto.setData((Serializable)dtxLockParams);
        return messageDto;
    }

    public static MessageDto notifyUnitOkResponse(Serializable message, String action) {
        MessageDto messageDto = new MessageDto();
        messageDto.setAction(action);
        messageDto.setState(200);
        messageDto.setData(message);
        return messageDto;
    }

    public static MessageDto notifyUnitFailResponse(Serializable message, String action) {
        MessageDto messageDto = new MessageDto();
        messageDto.setState(500);
        messageDto.setAction(action);
        messageDto.setData(message);
        return messageDto;
    }

    public static MessageDto askTransactionState(String groupId, String unitId) {
        MessageDto messageDto = new MessageDto();
        messageDto.setGroupId(groupId);
        messageDto.setAction("askTransactionState");
        messageDto.setData((Serializable)new AskTransactionStateParams(groupId, unitId));
        return messageDto;
    }

    public static MessageDto writeTxException(TxExceptionParams txExceptionParams) {
        MessageDto messageDto = new MessageDto();
        messageDto.setAction("writeException");
        messageDto.setGroupId(txExceptionParams.getGroupId());
        messageDto.setData((Serializable)txExceptionParams);
        return messageDto;
    }

    public static MessageDto initClient(String appName, String labelName) {
        InitClientParams initClientParams = new InitClientParams();
        initClientParams.setAppName(appName);
        initClientParams.setLabelName(labelName);
        MessageDto messageDto = new MessageDto();
        messageDto.setData((Serializable)initClientParams);
        messageDto.setAction("init");
        return messageDto;
    }
}

