/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.tc.support.p6spy.wrapper;

import com.codingapi.txlcn.tc.support.p6spy.common.CallableStatementInformation;
import com.codingapi.txlcn.tc.support.p6spy.common.ConnectionInformation;
import com.codingapi.txlcn.tc.support.p6spy.common.PreparedStatementInformation;
import com.codingapi.txlcn.tc.support.p6spy.common.StatementInformation;
import com.codingapi.txlcn.tc.support.p6spy.event.JdbcEventListener;
import com.codingapi.txlcn.tc.support.p6spy.wrapper.AbstractWrapper;
import com.codingapi.txlcn.tc.support.p6spy.wrapper.CallableStatementWrapper;
import com.codingapi.txlcn.tc.support.p6spy.wrapper.PreparedStatementWrapper;
import com.codingapi.txlcn.tc.support.p6spy.wrapper.StatementWrapper;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionWrapper
extends AbstractWrapper
implements Connection {
    private static final Logger log = LoggerFactory.getLogger(ConnectionWrapper.class);
    private final Connection delegate;
    private final JdbcEventListener jdbcEventListener;
    private final ConnectionInformation connectionInformation;

    public static ConnectionWrapper wrap(Connection delegate, JdbcEventListener eventListener, ConnectionInformation connectionInformation) {
        if (delegate == null) {
            return null;
        }
        ConnectionWrapper connectionWrapper = new ConnectionWrapper(delegate, eventListener, connectionInformation);
        eventListener.onConnectionWrapped(connectionInformation);
        return connectionWrapper;
    }

    protected ConnectionWrapper(Connection delegate, JdbcEventListener jdbcEventListener, ConnectionInformation connectionInformation) {
        super(delegate);
        if (delegate == null) {
            throw new NullPointerException("Delegate must not be null");
        }
        this.delegate = delegate;
        this.connectionInformation = connectionInformation;
        this.jdbcEventListener = jdbcEventListener;
    }

    public JdbcEventListener getJdbcEventListener() {
        return this.jdbcEventListener;
    }

    public JdbcEventListener getEventListener() {
        return this.jdbcEventListener;
    }

    public Connection getDelegate() {
        return this.delegate;
    }

    public ConnectionInformation getConnectionInformation() {
        return this.connectionInformation;
    }

    @Override
    public Statement createStatement() throws SQLException {
        return StatementWrapper.wrap(this.delegate.createStatement(), new StatementInformation(this.connectionInformation), this.jdbcEventListener);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return StatementWrapper.wrap(this.delegate.createStatement(resultSetType, resultSetConcurrency), new StatementInformation(this.connectionInformation), this.jdbcEventListener);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return StatementWrapper.wrap(this.delegate.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability), new StatementInformation(this.connectionInformation), this.jdbcEventListener);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return PreparedStatementWrapper.wrap(this.delegate.prepareStatement(sql), new PreparedStatementInformation(this.connectionInformation, sql), this.jdbcEventListener);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return PreparedStatementWrapper.wrap(this.delegate.prepareStatement(sql, resultSetType, resultSetConcurrency), new PreparedStatementInformation(this.connectionInformation, sql), this.jdbcEventListener);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return PreparedStatementWrapper.wrap(this.delegate.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability), new PreparedStatementInformation(this.connectionInformation, sql), this.jdbcEventListener);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return PreparedStatementWrapper.wrap(this.delegate.prepareStatement(sql, autoGeneratedKeys), new PreparedStatementInformation(this.connectionInformation, sql), this.jdbcEventListener);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return PreparedStatementWrapper.wrap(this.delegate.prepareStatement(sql, columnIndexes), new PreparedStatementInformation(this.connectionInformation, sql), this.jdbcEventListener);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return PreparedStatementWrapper.wrap(this.delegate.prepareStatement(sql, columnNames), new PreparedStatementInformation(this.connectionInformation, sql), this.jdbcEventListener);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return CallableStatementWrapper.wrap(this.delegate.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability), new CallableStatementInformation(this.connectionInformation, sql), this.jdbcEventListener);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return CallableStatementWrapper.wrap(this.delegate.prepareCall(sql), new CallableStatementInformation(this.connectionInformation, sql), this.jdbcEventListener);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return CallableStatementWrapper.wrap(this.delegate.prepareCall(sql, resultSetType, resultSetConcurrency), new CallableStatementInformation(this.connectionInformation, sql), this.jdbcEventListener);
    }

    @Override
    public void commit() throws SQLException {
        log.debug("transaction type[txc] proxy connection:{} committed.", (Object)this);
        SQLException e = null;
        long start = System.nanoTime();
        try {
            this.jdbcEventListener.onBeforeCommit(this.connectionInformation);
            this.delegate.commit();
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.jdbcEventListener.onAfterCommit(this.connectionInformation, System.nanoTime() - start, e);
        }
    }

    @Override
    public void rollback() throws SQLException {
        log.debug("transaction type[txc] proxy connection:{} rolled back.", (Object)this);
        SQLException e = null;
        long start = System.nanoTime();
        try {
            this.jdbcEventListener.onBeforeRollback(this.connectionInformation);
            this.delegate.rollback();
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.jdbcEventListener.onAfterRollback(this.connectionInformation, System.nanoTime() - start, e);
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        SQLException e = null;
        long start = System.nanoTime();
        try {
            this.jdbcEventListener.onBeforeRollback(this.connectionInformation);
            this.delegate.rollback(savepoint);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.jdbcEventListener.onAfterRollback(this.connectionInformation, System.nanoTime() - start, e);
        }
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return this.delegate.nativeSQL(sql);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.delegate.setAutoCommit(autoCommit);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.delegate.getAutoCommit();
    }

    @Override
    public void close() throws SQLException {
        log.debug("transaction type[txc] proxy connection:{} closed.", (Object)this);
        SQLException e = null;
        try {
            this.delegate.close();
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.jdbcEventListener.onAfterConnectionClose(this.connectionInformation, e);
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.delegate.isClosed();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.delegate.getMetaData();
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.delegate.setReadOnly(readOnly);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.delegate.isReadOnly();
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.delegate.setCatalog(catalog);
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.delegate.getCatalog();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.delegate.setTransactionIsolation(level);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.delegate.getTransactionIsolation();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.delegate.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.delegate.clearWarnings();
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.delegate.getTypeMap();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.delegate.setTypeMap(map);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.delegate.setHoldability(holdability);
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.delegate.getHoldability();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.delegate.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        return this.delegate.setSavepoint(name);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.delegate.releaseSavepoint(savepoint);
    }

    @Override
    public Clob createClob() throws SQLException {
        return this.delegate.createClob();
    }

    @Override
    public Blob createBlob() throws SQLException {
        return this.delegate.createBlob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        return this.delegate.createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return this.delegate.createSQLXML();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return this.delegate.isValid(timeout);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.delegate.setClientInfo(name, value);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.delegate.setClientInfo(properties);
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this.delegate.getClientInfo(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.delegate.getClientInfo();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return this.delegate.createArrayOf(typeName, elements);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return this.delegate.createStruct(typeName, attributes);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.delegate.setSchema(schema);
    }

    @Override
    public String getSchema() throws SQLException {
        return this.delegate.getSchema();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.delegate.abort(executor);
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.delegate.setNetworkTimeout(executor, milliseconds);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return this.delegate.getNetworkTimeout();
    }
}

