/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.tc.support.p6spy.common;

import com.codingapi.txlcn.tc.support.p6spy.common.ConnectionInformation;
import com.codingapi.txlcn.tc.support.p6spy.common.Loggable;
import com.codingapi.txlcn.tc.support.p6spy.common.StatementInformation;
import com.codingapi.txlcn.tc.support.p6spy.common.Value;
import java.util.HashMap;
import java.util.Map;

public class PreparedStatementInformation
extends StatementInformation
implements Loggable {
    private final Map<Integer, Value> parameterValues = new HashMap<Integer, Value>();

    public PreparedStatementInformation(ConnectionInformation connectionInformation, String query) {
        super(connectionInformation);
        this.setStatementQuery(query);
    }

    @Override
    public String getSqlWithValues() {
        StringBuilder sb = new StringBuilder();
        String statementQuery = this.getStatementQuery();
        int currentParameter = 0;
        for (int pos = 0; pos < statementQuery.length(); ++pos) {
            char character = statementQuery.charAt(pos);
            if (statementQuery.charAt(pos) == '?' && currentParameter <= this.parameterValues.size()) {
                Value value = this.parameterValues.get(currentParameter);
                sb.append(value != null ? value.toString() : new Value().toString());
                ++currentParameter;
                continue;
            }
            sb.append(character);
        }
        return sb.toString();
    }

    public void setParameterValue(int position, Object value) {
        this.parameterValues.put(position - 1, new Value(value));
    }

    protected Map<Integer, Value> getParameterValues() {
        return this.parameterValues;
    }
}

