/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.tc.support.p6spy.common;

import com.codingapi.txlcn.tc.support.p6spy.common.Hasher;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class CustomHashedHashSet<T>
extends HashSet<T> {
    private transient Map<Integer, T> map = new HashMap<Integer, T>();
    final transient Hasher hasher;

    public CustomHashedHashSet(Hasher hasher) {
        this.hasher = hasher;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        for (Object o : c) {
            if (!this.contains(o)) continue;
            this.remove(o);
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean modified = false;
        for (T o : c) {
            if (!this.add(o)) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean modified = false;
        for (Object o : c) {
            if (this.contains(o)) continue;
            this.remove(o);
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(this.hasher.getHashCode(o));
    }

    @Override
    public boolean add(T o) {
        int hash = this.hasher.getHashCode(o);
        if (!this.map.containsKey(hash)) {
            this.map.put(hash, o);
            super.add(o);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        int hash = this.hasher.getHashCode(o);
        if (this.map.containsKey(hash)) {
            super.remove(this.map.get(hash));
            this.map.remove(hash);
            return true;
        }
        return false;
    }

    @Override
    public Iterator<T> iterator() {
        return new CustomHashedHashSetIterator(super.iterator());
    }

    @Override
    public void clear() {
        this.map.clear();
        super.clear();
    }

    @Override
    public Object clone() {
        throw new UnsupportedOperationException();
    }

    class CustomHashedHashSetIterator<E>
    implements Iterator<E> {
        private final Iterator<E> iterator;

        public CustomHashedHashSetIterator(Iterator<E> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public E next() {
            return this.iterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

