/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.tc.core.transaction.tcc.control;

import com.codingapi.txlcn.common.exception.TransactionClearException;
import com.codingapi.txlcn.common.util.Maps;
import com.codingapi.txlcn.tc.core.DTXLocalContext;
import com.codingapi.txlcn.tc.core.TccTransactionInfo;
import com.codingapi.txlcn.tc.core.TransactionCleanService;
import com.codingapi.txlcn.tc.core.context.TCGlobalContext;
import com.codingapi.txlcn.tc.txmsg.TMReporter;
import com.codingapi.txlcn.tracing.TracingContext;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class TccTransactionCleanService
implements TransactionCleanService {
    private static final Logger log = LoggerFactory.getLogger(TccTransactionCleanService.class);
    private final ApplicationContext applicationContext;
    private final TMReporter tmReporter;
    private final TCGlobalContext globalContext;

    @Autowired
    public TccTransactionCleanService(ApplicationContext applicationContext, TMReporter tmReporter, TCGlobalContext globalContext) {
        this.applicationContext = applicationContext;
        this.tmReporter = tmReporter;
        this.globalContext = globalContext;
    }

    @Override
    public void clear(String groupId, int state, String unitId, String unitType) throws TransactionClearException {
        boolean shouldDestroy = !TracingContext.tracing().hasGroup();
        try {
            TccTransactionInfo tccInfo = this.globalContext.tccTransactionInfo(unitId, null);
            Object object = this.applicationContext.getBean(tccInfo.getExecuteClass());
            if (Objects.isNull(DTXLocalContext.cur())) {
                DTXLocalContext.getOrNew().setJustNow(true);
            }
            if (shouldDestroy) {
                TracingContext.init((Map)Maps.of((Object)"groupId", (Object)groupId, (Object)"appMap", (Object)"{}"));
            }
            DTXLocalContext.getOrNew().setGroupId(groupId);
            DTXLocalContext.cur().setUnitId(unitId);
            Method exeMethod = tccInfo.getExecuteClass().getMethod(state == 1 ? tccInfo.getConfirmMethod() : tccInfo.getCancelMethod(), tccInfo.getMethodTypeParameter());
            try {
                exeMethod.invoke(object, tccInfo.getMethodParameter());
                log.debug("User confirm/cancel logic over.");
            }
            catch (Throwable e) {
                log.error("Tcc clean error.", e);
                this.tmReporter.reportTccCleanException(groupId, unitId, state);
            }
        }
        catch (Throwable e) {
            throw new TransactionClearException(e.getMessage());
        }
        finally {
            if (DTXLocalContext.cur().isJustNow()) {
                DTXLocalContext.makeNeverAppeared();
            }
            if (shouldDestroy) {
                TracingContext.tracing().destroy();
            }
        }
    }
}

