/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.tc.core.transaction.lcn.resource;

import com.codingapi.txlcn.common.exception.TCGlobalContextException;
import com.codingapi.txlcn.tc.aspect.weave.ConnectionCallback;
import com.codingapi.txlcn.tc.core.DTXLocalContext;
import com.codingapi.txlcn.tc.core.context.TCGlobalContext;
import com.codingapi.txlcn.tc.core.transaction.lcn.resource.LcnConnectionProxy;
import com.codingapi.txlcn.tc.support.resouce.TransactionResourceProxy;
import java.sql.Connection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="transaction_lcn")
public class LcnTransactionResourceProxy
implements TransactionResourceProxy {
    private static final Logger log = LoggerFactory.getLogger(LcnTransactionResourceProxy.class);
    private final TCGlobalContext globalContext;

    @Autowired
    public LcnTransactionResourceProxy(TCGlobalContext globalContext) {
        this.globalContext = globalContext;
    }

    @Override
    public Connection proxyConnection(ConnectionCallback connectionCallback) throws Throwable {
        String groupId = DTXLocalContext.cur().getGroupId();
        try {
            return this.globalContext.getLcnConnection(groupId);
        }
        catch (TCGlobalContextException e) {
            LcnConnectionProxy lcnConnectionProxy = new LcnConnectionProxy(connectionCallback.call());
            this.globalContext.setLcnConnection(groupId, lcnConnectionProxy);
            lcnConnectionProxy.setAutoCommit(false);
            return lcnConnectionProxy;
        }
    }
}

