/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.dashscope.rag;

import com.alibaba.cloud.ai.dashscope.api.DashScopeApi;
import com.alibaba.cloud.ai.dashscope.common.DashScopeException;
import com.alibaba.cloud.ai.dashscope.rag.DashScopeDocumentRetrieverOptions;
import java.util.List;
import org.springframework.ai.document.Document;
import org.springframework.ai.rag.Query;
import org.springframework.ai.rag.retrieval.search.DocumentRetriever;
import org.springframework.util.Assert;

public class DashScopeDocumentRetriever
implements DocumentRetriever {
    private final DashScopeDocumentRetrieverOptions options;
    private final DashScopeApi dashScopeApi;

    public DashScopeDocumentRetriever(DashScopeApi dashScopeApi, DashScopeDocumentRetrieverOptions options) {
        Assert.notNull((Object)options, (String)"RetrieverOptions must not be null");
        Assert.notNull((Object)options.getIndexName(), (String)"IndexName must not be null");
        this.options = options;
        this.dashScopeApi = dashScopeApi;
    }

    public List<Document> retrieve(Query query) {
        String pipelineId = this.dashScopeApi.getPipelineIdByName(this.options.getIndexName());
        if (pipelineId == null) {
            throw new DashScopeException("Index:" + this.options.getIndexName() + " NotExist");
        }
        List<Document> documentList = this.dashScopeApi.retriever(pipelineId, query.text(), this.options);
        return documentList;
    }
}

