/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.dashscope.chat;

import com.alibaba.cloud.ai.dashscope.api.DashScopeApi;
import com.alibaba.cloud.ai.dashscope.chat.DashScopeChatOptions;
import com.alibaba.cloud.ai.dashscope.chat.MessageFormat;
import com.alibaba.cloud.ai.dashscope.chat.observation.DashScopeChatModelObservationConvention;
import com.alibaba.cloud.ai.dashscope.common.DashScopeApiConstants;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.ObservationRegistry;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.messages.AssistantMessage;
import org.springframework.ai.chat.messages.MessageType;
import org.springframework.ai.chat.messages.ToolResponseMessage;
import org.springframework.ai.chat.messages.UserMessage;
import org.springframework.ai.chat.metadata.ChatGenerationMetadata;
import org.springframework.ai.chat.metadata.ChatResponseMetadata;
import org.springframework.ai.chat.metadata.DefaultUsage;
import org.springframework.ai.chat.metadata.EmptyUsage;
import org.springframework.ai.chat.metadata.Usage;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.ai.chat.model.Generation;
import org.springframework.ai.chat.model.MessageAggregator;
import org.springframework.ai.chat.observation.ChatModelObservationContext;
import org.springframework.ai.chat.observation.ChatModelObservationConvention;
import org.springframework.ai.chat.observation.ChatModelObservationDocumentation;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.chat.prompt.Prompt;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.model.tool.DefaultToolExecutionEligibilityPredicate;
import org.springframework.ai.model.tool.ToolCallingChatOptions;
import org.springframework.ai.model.tool.ToolCallingManager;
import org.springframework.ai.model.tool.ToolExecutionEligibilityPredicate;
import org.springframework.ai.model.tool.ToolExecutionResult;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.ai.support.UsageCalculator;
import org.springframework.ai.tool.definition.ToolDefinition;
import org.springframework.http.ResponseEntity;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MimeType;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class DashScopeChatModel
implements ChatModel {
    private static final Logger logger = LoggerFactory.getLogger(DashScopeChatModel.class);
    public static final String DEFAULT_MODEL_NAME = DashScopeApi.DEFAULT_CHAT_MODEL;
    public static final Double DEFAULT_TEMPERATURE = 0.7;
    private static final ChatModelObservationConvention DEFAULT_OBSERVATION_CONVENTION = new DashScopeChatModelObservationConvention();
    private static final ToolCallingManager DEFAULT_TOOL_CALLING_MANAGER = ToolCallingManager.builder().build();
    private DashScopeChatOptions defaultOptions;
    private final DashScopeApi dashscopeApi;
    public final RetryTemplate retryTemplate;
    private final ObservationRegistry observationRegistry;
    private final ToolCallingManager toolCallingManager;
    private final ToolExecutionEligibilityPredicate toolExecutionEligibilityPredicate;
    private ChatModelObservationConvention observationConvention = DEFAULT_OBSERVATION_CONVENTION;

    public DashScopeChatModel(DashScopeApi dashscopeApi, DashScopeChatOptions defaultOptions, ToolCallingManager toolCallingManager, RetryTemplate retryTemplate, ObservationRegistry observationRegistry, ToolExecutionEligibilityPredicate toolExecutionEligibilityPredicate) {
        Assert.notNull((Object)dashscopeApi, (String)"dashscopeApi cannot be null");
        Assert.notNull((Object)defaultOptions, (String)"defaultOptions cannot be null");
        Assert.notNull((Object)toolCallingManager, (String)"toolCallingManager cannot be null");
        Assert.notNull((Object)retryTemplate, (String)"retryTemplate cannot be null");
        Assert.notNull((Object)observationRegistry, (String)"observationRegistry cannot be null");
        Assert.notNull((Object)toolExecutionEligibilityPredicate, (String)"toolExecutionEligibilityPredicate cannot be null");
        this.dashscopeApi = dashscopeApi;
        this.defaultOptions = defaultOptions;
        this.toolCallingManager = toolCallingManager;
        this.retryTemplate = retryTemplate;
        this.observationRegistry = observationRegistry;
        this.toolExecutionEligibilityPredicate = toolExecutionEligibilityPredicate;
    }

    public ChatResponse call(Prompt prompt) {
        Assert.notNull((Object)prompt, (String)"Prompt must not be null");
        Assert.isTrue((!CollectionUtils.isEmpty((Collection)prompt.getInstructions()) ? 1 : 0) != 0, (String)"Prompt messages must not be empty");
        Prompt requestPrompt = this.buildRequestPrompt(prompt);
        return this.internalCall(requestPrompt, null);
    }

    public ChatOptions getDefaultOptions() {
        return DashScopeChatOptions.fromOptions(this.defaultOptions);
    }

    public ChatResponse internalCall(Prompt prompt, ChatResponse previousChatResponse) {
        DashScopeApi.ChatCompletionRequest request = this.createRequest(prompt, false);
        ChatModelObservationContext observationContext = ChatModelObservationContext.builder().prompt(prompt).provider(DashScopeApiConstants.PROVIDER_NAME).build();
        ChatResponse response = (ChatResponse)ChatModelObservationDocumentation.CHAT_MODEL_OPERATION.observation((ObservationConvention)this.observationConvention, (ObservationConvention)DEFAULT_OBSERVATION_CONVENTION, () -> observationContext, this.observationRegistry).observe(() -> {
            ResponseEntity completionEntity = (ResponseEntity)this.retryTemplate.execute(ctx -> this.dashscopeApi.chatCompletionEntity(request));
            DashScopeApi.ChatCompletion completionResponse = (DashScopeApi.ChatCompletion)completionEntity.getBody();
            ChatResponse chatResponse = this.toChatResponse(completionResponse, previousChatResponse, request, null);
            observationContext.setResponse((Object)chatResponse);
            return chatResponse;
        });
        if (this.toolExecutionEligibilityPredicate.isToolExecutionRequired(prompt.getOptions(), response)) {
            ToolExecutionResult toolExecutionResult = this.toolCallingManager.executeToolCalls(prompt, response);
            if (toolExecutionResult.returnDirect()) {
                return ChatResponse.builder().from(response).generations(ToolExecutionResult.buildGenerations((ToolExecutionResult)toolExecutionResult)).build();
            }
            return this.internalCall(new Prompt(toolExecutionResult.conversationHistory(), prompt.getOptions()), response);
        }
        return response;
    }

    public Flux<ChatResponse> stream(Prompt prompt) {
        Assert.notNull((Object)prompt, (String)"Prompt must not be null");
        Assert.isTrue((!CollectionUtils.isEmpty((Collection)prompt.getInstructions()) ? 1 : 0) != 0, (String)"Prompt messages must not be empty");
        Prompt requestPrompt = this.buildRequestPrompt(prompt);
        return this.internalStream(requestPrompt, null);
    }

    public Flux<ChatResponse> internalStream(Prompt prompt, ChatResponse previousChatResponse) {
        return Flux.deferContextual(contextView -> {
            DashScopeApi.ChatCompletionRequest request = this.createRequest(prompt, true);
            Flux completionChunks = (Flux)this.retryTemplate.execute(ctx -> this.dashscopeApi.chatCompletionStream(request));
            ConcurrentHashMap roleMap = new ConcurrentHashMap();
            ChatModelObservationContext observationContext = ChatModelObservationContext.builder().prompt(prompt).provider(DashScopeApiConstants.PROVIDER_NAME).build();
            Observation observation = ChatModelObservationDocumentation.CHAT_MODEL_OPERATION.observation((ObservationConvention)this.observationConvention, (ObservationConvention)DEFAULT_OBSERVATION_CONVENTION, () -> observationContext, this.observationRegistry);
            observation.parentObservation((Observation)contextView.getOrDefault((Object)"micrometer.observation", null)).start();
            Flux chatResponse = completionChunks.map(this::chunkToChatCompletion).switchMap(chatCompletion -> Mono.just((Object)chatCompletion).map(chatCompletion2 -> this.toChatResponse((DashScopeApi.ChatCompletion)chatCompletion2, previousChatResponse, request, roleMap)));
            Flux flux = chatResponse.flatMap(response -> {
                if (this.toolExecutionEligibilityPredicate.isToolExecutionRequired(prompt.getOptions(), response)) {
                    return Flux.defer(() -> {
                        ToolExecutionResult toolExecutionResult = this.toolCallingManager.executeToolCalls(prompt, response);
                        if (toolExecutionResult.returnDirect()) {
                            return Flux.just((Object)ChatResponse.builder().from(response).generations(ToolExecutionResult.buildGenerations((ToolExecutionResult)toolExecutionResult)).build());
                        }
                        return this.internalStream(new Prompt(toolExecutionResult.conversationHistory(), prompt.getOptions()), (ChatResponse)response);
                    }).subscribeOn(Schedulers.boundedElastic());
                }
                return Flux.just((Object)response);
            }).doOnError(arg_0 -> ((Observation)observation).error(arg_0)).doFinally(s -> observation.stop()).contextWrite(ctx -> ctx.put((Object)"micrometer.observation", (Object)observation));
            return new MessageAggregator().aggregate(flux, arg_0 -> ((ChatModelObservationContext)observationContext).setResponse(arg_0));
        });
    }

    private ChatResponse toChatResponse(DashScopeApi.ChatCompletion chatCompletion, ChatResponse previousChatResponse, DashScopeApi.ChatCompletionRequest request, ConcurrentHashMap<String, String> roleMap) {
        if (chatCompletion == null) {
            logger.warn("Null chat completion returned");
            return new ChatResponse(List.of());
        }
        List<DashScopeApi.ChatCompletionOutput.Choice> choices = chatCompletion.output().choices();
        if (choices == null) {
            logger.warn("No choices returned");
            return new ChatResponse(List.of());
        }
        ConcurrentHashMap finalRoleMap = roleMap == null ? new ConcurrentHashMap() : roleMap;
        List<Generation> generations = choices.stream().map(choice -> {
            if (choice.message().role() != null) {
                finalRoleMap.putIfAbsent(chatCompletion.requestId(), choice.message().role().name());
            }
            Map<String, Object> metadata = Map.of("id", chatCompletion.requestId(), "role", finalRoleMap.getOrDefault(chatCompletion.requestId(), ""), "finishReason", choice.finishReason() != null ? choice.finishReason().name() : "", "reasoningContent", StringUtils.hasText((String)choice.message().reasoningContent()) ? choice.message().reasoningContent() : "");
            return DashScopeChatModel.buildGeneration(choice, metadata, request);
        }).toList();
        DashScopeApi.TokenUsage usage = chatCompletion.usage();
        EmptyUsage currentChatResponseUsage = usage != null ? this.getDefaultUsage(usage) : new EmptyUsage();
        Usage accumulatedUsage = UsageCalculator.getCumulativeUsage((Usage)currentChatResponseUsage, (ChatResponse)previousChatResponse);
        return new ChatResponse(generations, this.from(chatCompletion, accumulatedUsage));
    }

    public DashScopeChatOptions getDashScopeChatOptions() {
        return this.defaultOptions;
    }

    public void setDashScopeChatOptions(DashScopeChatOptions options) {
        this.defaultOptions = options;
    }

    private static Generation buildGeneration(DashScopeApi.ChatCompletionOutput.Choice choice, Map<String, Object> metadata, DashScopeApi.ChatCompletionRequest request) {
        List toolCalls = choice.message().toolCalls() == null ? List.of() : choice.message().toolCalls().stream().map(toolCall -> new AssistantMessage.ToolCall(toolCall.id(), "function", toolCall.function().name(), toolCall.function().arguments())).toList();
        String finishReason = choice.finishReason() != null ? choice.finishReason().name() : "";
        ChatGenerationMetadata.Builder generationMetadataBuilder = ChatGenerationMetadata.builder().finishReason(finishReason);
        AssistantMessage assistantMessage = new AssistantMessage(choice.message().content(), metadata, toolCalls);
        return new Generation(assistantMessage, generationMetadataBuilder.build());
    }

    private DashScopeApi.ChatCompletion chunkToChatCompletion(DashScopeApi.ChatCompletionChunk chunk) {
        return new DashScopeApi.ChatCompletion(chunk.requestId(), new DashScopeApi.ChatCompletionOutput(chunk.output().text(), chunk.output().choices()), chunk.usage());
    }

    private ChatResponseMetadata from(DashScopeApi.ChatCompletion result, Usage usage) {
        Assert.notNull((Object)result, (String)"DashScopeAi ChatCompletionResult must not be null");
        return ChatResponseMetadata.builder().id(result.requestId()).usage(usage).model("").build();
    }

    private DefaultUsage getDefaultUsage(DashScopeApi.TokenUsage usage) {
        return new DefaultUsage(usage.inputTokens(), usage.outputTokens(), Integer.valueOf(usage.inputTokens() + usage.outputTokens()), (Object)usage);
    }

    Prompt buildRequestPrompt(Prompt prompt) {
        DashScopeChatOptions runtimeOptions = null;
        if (prompt.getOptions() != null) {
            ChatOptions chatOptions = prompt.getOptions();
            if (chatOptions instanceof ToolCallingChatOptions) {
                ToolCallingChatOptions toolCallingChatOptions = (ToolCallingChatOptions)chatOptions;
                runtimeOptions = (DashScopeChatOptions)ModelOptionsUtils.copyToTarget((Object)toolCallingChatOptions, ToolCallingChatOptions.class, DashScopeChatOptions.class);
            } else {
                runtimeOptions = (DashScopeChatOptions)ModelOptionsUtils.copyToTarget((Object)prompt.getOptions(), ChatOptions.class, DashScopeChatOptions.class);
            }
        }
        DashScopeChatOptions requestOptions = (DashScopeChatOptions)ModelOptionsUtils.merge(runtimeOptions, (Object)this.defaultOptions, DashScopeChatOptions.class);
        if (runtimeOptions != null) {
            requestOptions.setInternalToolExecutionEnabled((Boolean)ModelOptionsUtils.mergeOption((Object)runtimeOptions.getInternalToolExecutionEnabled(), (Object)this.defaultOptions.getInternalToolExecutionEnabled()));
            requestOptions.setToolNames(ToolCallingChatOptions.mergeToolNames(runtimeOptions.getToolNames(), this.defaultOptions.getToolNames()));
            requestOptions.setToolCallbacks(ToolCallingChatOptions.mergeToolCallbacks(runtimeOptions.getToolCallbacks(), this.defaultOptions.getToolCallbacks()));
            requestOptions.setToolContext(ToolCallingChatOptions.mergeToolContext(runtimeOptions.getToolContext(), this.defaultOptions.getToolContext()));
        } else {
            requestOptions.setInternalToolExecutionEnabled(this.defaultOptions.getInternalToolExecutionEnabled());
            requestOptions.setToolNames(this.defaultOptions.getToolNames());
            requestOptions.setToolCallbacks(this.defaultOptions.getToolCallbacks());
            requestOptions.setToolContext(this.defaultOptions.getToolContext());
        }
        ToolCallingChatOptions.validateToolCallbacks(requestOptions.getToolCallbacks());
        return new Prompt(prompt.getInstructions(), (ChatOptions)requestOptions);
    }

    DashScopeApi.ChatCompletionRequest createRequest(Prompt prompt, boolean stream) {
        List<DashScopeApi.ChatCompletionMessage> chatCompletionMessages = prompt.getInstructions().stream().map(message -> {
            if (message.getMessageType() == MessageType.USER || message.getMessageType() == MessageType.SYSTEM) {
                UserMessage userMessage;
                Object content = message.getText();
                if (message instanceof UserMessage && !CollectionUtils.isEmpty((Collection)(userMessage = (UserMessage)message).getMedia())) {
                    content = this.convertMediaContent(userMessage);
                }
                return List.of(new DashScopeApi.ChatCompletionMessage(content, DashScopeApi.ChatCompletionMessage.Role.valueOf(message.getMessageType().name())));
            }
            if (message.getMessageType() == MessageType.ASSISTANT) {
                AssistantMessage assistantMessage = (AssistantMessage)message;
                List<DashScopeApi.ChatCompletionMessage.ToolCall> toolCalls = null;
                if (!CollectionUtils.isEmpty((Collection)assistantMessage.getToolCalls())) {
                    toolCalls = assistantMessage.getToolCalls().stream().map(toolCall -> {
                        DashScopeApi.ChatCompletionMessage.ChatCompletionFunction function = new DashScopeApi.ChatCompletionMessage.ChatCompletionFunction(toolCall.name(), toolCall.arguments());
                        return new DashScopeApi.ChatCompletionMessage.ToolCall(toolCall.id(), toolCall.type(), function);
                    }).toList();
                }
                return List.of(new DashScopeApi.ChatCompletionMessage(assistantMessage.getText(), DashScopeApi.ChatCompletionMessage.Role.ASSISTANT, null, null, toolCalls, null));
            }
            if (message.getMessageType() == MessageType.TOOL) {
                ToolResponseMessage toolMessage = (ToolResponseMessage)message;
                toolMessage.getResponses().forEach(response -> {
                    Assert.isTrue((response.id() != null ? 1 : 0) != 0, (String)"ToolResponseMessage must have an id");
                    Assert.isTrue((response.name() != null ? 1 : 0) != 0, (String)"ToolResponseMessage must have a name");
                });
                return toolMessage.getResponses().stream().map(tr -> new DashScopeApi.ChatCompletionMessage(tr.responseData(), DashScopeApi.ChatCompletionMessage.Role.TOOL, tr.name(), tr.id(), null, null)).toList();
            }
            throw new IllegalArgumentException("Unsupported message type: " + message.getMessageType());
        }).flatMap(Collection::stream).toList();
        DashScopeChatOptions requestOptions = (DashScopeChatOptions)prompt.getOptions();
        List toolDefinitions = this.toolCallingManager.resolveToolDefinitions((ToolCallingChatOptions)requestOptions);
        if (!CollectionUtils.isEmpty((Collection)toolDefinitions)) {
            requestOptions.setTools(this.getFunctionTools(toolDefinitions));
        }
        boolean multiModel = requestOptions.getMultiModel();
        return new DashScopeApi.ChatCompletionRequest(requestOptions.getModel(), new DashScopeApi.ChatCompletionRequestInput(chatCompletionMessages), this.toDashScopeRequestParameter(requestOptions, stream), stream, multiModel);
    }

    private List<DashScopeApi.ChatCompletionMessage.MediaContent> convertMediaContent(UserMessage message) {
        MessageFormat format = MessageFormat.IMAGE;
        Object v = message.getMetadata().get("messageFormat");
        if (v instanceof MessageFormat) {
            MessageFormat messageFormat;
            format = messageFormat = (MessageFormat)((Object)v);
        }
        ArrayList<DashScopeApi.ChatCompletionMessage.MediaContent> contentList = new ArrayList<DashScopeApi.ChatCompletionMessage.MediaContent>();
        if (format == MessageFormat.VIDEO) {
            mediaContent = new DashScopeApi.ChatCompletionMessage.MediaContent(message.getText());
            contentList.add(mediaContent);
            List<String> mediaList = message.getMedia().stream().map(media -> this.fromMediaData(media.getMimeType(), media.getData())).toList();
            contentList.add(new DashScopeApi.ChatCompletionMessage.MediaContent("video", null, null, mediaList));
        } else {
            mediaContent = new DashScopeApi.ChatCompletionMessage.MediaContent(message.getText());
            contentList.add(mediaContent);
            contentList.addAll(message.getMedia().stream().map(media -> new DashScopeApi.ChatCompletionMessage.MediaContent("image", null, this.fromMediaData(media.getMimeType(), media.getData()), null)).toList());
        }
        return contentList;
    }

    private String fromMediaData(MimeType mimeType, Object mediaContentData) {
        if (mediaContentData instanceof byte[]) {
            byte[] bytes = (byte[])mediaContentData;
            return String.format("data:%s;base64,%s", mimeType.toString(), Base64.getEncoder().encodeToString(bytes));
        }
        if (mediaContentData instanceof String) {
            String text = (String)mediaContentData;
            return text;
        }
        throw new IllegalArgumentException("Unsupported media data type: " + mediaContentData.getClass().getSimpleName());
    }

    private List<DashScopeApi.FunctionTool> getFunctionTools(List<ToolDefinition> toolDefinitions) {
        return toolDefinitions.stream().map(toolDefinition -> {
            DashScopeApi.FunctionTool.Function function = new DashScopeApi.FunctionTool.Function(toolDefinition.description(), toolDefinition.name(), toolDefinition.inputSchema());
            return new DashScopeApi.FunctionTool(function);
        }).toList();
    }

    private DashScopeApi.ChatCompletionRequestParameter toDashScopeRequestParameter(DashScopeChatOptions options, boolean stream) {
        if (options == null) {
            return new DashScopeApi.ChatCompletionRequestParameter();
        }
        Boolean incrementalOutput = stream && options.getIncrementalOutput() != false;
        return new DashScopeApi.ChatCompletionRequestParameter("message", options.getSeed(), options.getMaxTokens(), options.getTopP(), options.getTopK(), options.getRepetitionPenalty(), options.getPresencePenalty(), options.getTemperature(), options.getStop(), options.getEnableSearch(), options.getResponseFormat(), incrementalOutput, options.getTools(), options.getToolChoice(), stream, options.getVlHighResolutionImages(), options.getEnableThinking());
    }

    public void setObservationConvention(ChatModelObservationConvention observationConvention) {
        Assert.notNull((Object)observationConvention, (String)"observationConvention cannot be null");
        this.observationConvention = observationConvention;
    }

    public Builder mutate() {
        return new Builder(this);
    }

    public DashScopeChatModel clone() {
        return this.mutate().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private DashScopeApi dashScopeApi;
        private DashScopeChatOptions defaultOptions = DashScopeChatOptions.builder().withModel(DEFAULT_MODEL_NAME).withTemperature(DEFAULT_TEMPERATURE).build();
        private RetryTemplate retryTemplate = RetryUtils.DEFAULT_RETRY_TEMPLATE;
        private ToolCallingManager toolCallingManager;
        private ToolExecutionEligibilityPredicate toolExecutionEligibilityPredicate = new DefaultToolExecutionEligibilityPredicate();
        private ObservationRegistry observationRegistry = ObservationRegistry.NOOP;

        private Builder() {
        }

        public Builder(DashScopeChatModel dashScopeChatModel) {
            this.dashScopeApi = dashScopeChatModel.dashscopeApi;
            this.defaultOptions = dashScopeChatModel.defaultOptions;
            this.toolCallingManager = dashScopeChatModel.toolCallingManager;
            this.retryTemplate = dashScopeChatModel.retryTemplate;
            this.observationRegistry = dashScopeChatModel.observationRegistry;
            this.toolExecutionEligibilityPredicate = dashScopeChatModel.toolExecutionEligibilityPredicate;
        }

        public Builder dashScopeApi(DashScopeApi dashScopeApi) {
            this.dashScopeApi = dashScopeApi;
            return this;
        }

        public Builder defaultOptions(DashScopeChatOptions defaultOptions) {
            this.defaultOptions = defaultOptions;
            return this;
        }

        public Builder toolExecutionEligibilityPredicate(ToolExecutionEligibilityPredicate toolExecutionEligibilityPredicate) {
            this.toolExecutionEligibilityPredicate = toolExecutionEligibilityPredicate;
            return this;
        }

        public Builder retryTemplate(RetryTemplate retryTemplate) {
            this.retryTemplate = retryTemplate;
            return this;
        }

        public Builder toolCallingManager(ToolCallingManager toolCallingManager) {
            this.toolCallingManager = toolCallingManager;
            return this;
        }

        public Builder observationRegistry(ObservationRegistry observationRegistry) {
            this.observationRegistry = observationRegistry;
            return this;
        }

        public DashScopeChatModel build() {
            if (this.toolCallingManager != null) {
                return new DashScopeChatModel(this.dashScopeApi, this.defaultOptions, this.toolCallingManager, this.retryTemplate, this.observationRegistry, this.toolExecutionEligibilityPredicate);
            }
            return new DashScopeChatModel(this.dashScopeApi, this.defaultOptions, DEFAULT_TOOL_CALLING_MANAGER, this.retryTemplate, this.observationRegistry, this.toolExecutionEligibilityPredicate);
        }
    }
}

