/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.dashscope.api;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;

public class ApiUtils {
    private static final String USER_AGENT = ApiUtils.userAgent();

    public static Consumer<HttpHeaders> getJsonContentHeaders(String apiKey) {
        return ApiUtils.getJsonContentHeaders(apiKey, null);
    }

    public static Consumer<HttpHeaders> getJsonContentHeaders(String apiKey, String workspaceId) {
        return ApiUtils.getJsonContentHeaders(apiKey, workspaceId, false);
    }

    public static Consumer<HttpHeaders> getJsonContentHeaders(String apiKey, String workspaceId, boolean stream) {
        return headers -> {
            headers.setBearerAuth(apiKey);
            headers.set("X-DashScope-OpenAPISource", "CloudSDK");
            headers.set("User-Agent", USER_AGENT);
            if (workspaceId != null) {
                headers.set("X-DashScope-WorkSpace", workspaceId);
            }
            headers.setContentType(MediaType.APPLICATION_JSON);
            if (stream) {
                headers.set("X-DashScope-SSE", "enable");
            }
        };
    }

    public static Map<String, String> getMapContentHeaders(String apiKey, boolean isSecurityCheck, String workspace, Map<String, String> customHeaders) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "bearer " + apiKey);
        headers.put("User-Agent", USER_AGENT);
        if (workspace != null && !workspace.isEmpty()) {
            headers.put("X-DashScope-WorkSpace", workspace);
        }
        if (isSecurityCheck) {
            headers.put("X-DashScope-DataInspection", "enable");
        }
        if (customHeaders != null && !customHeaders.isEmpty()) {
            headers.putAll(customHeaders);
        }
        return headers;
    }

    public static Consumer<HttpHeaders> getAudioTranscriptionHeaders(String apiKey, String workspace, Boolean isAsyncTask, Boolean isSecurityCheck, Boolean isSSE) {
        return headers -> {
            headers.setBearerAuth(apiKey);
            headers.set("User-Agent", USER_AGENT);
            if (isSecurityCheck.booleanValue()) {
                headers.set("X-DashScope-DataInspection", "enable");
            }
            if (workspace != null && !workspace.isEmpty()) {
                headers.set("X-DashScope-WorkSpace", workspace);
            }
            if (isAsyncTask.booleanValue()) {
                headers.set("X-DashScope-Async", "enable");
            }
            headers.setContentType(MediaType.APPLICATION_JSON);
            if (isSSE.booleanValue()) {
                headers.set("Cache-Control", "no-cache");
                headers.setAccept(List.of(MediaType.TEXT_EVENT_STREAM));
                headers.set("X-Accel-Buffering", "no");
                headers.set("X-DashScope-SSE", "enable");
            } else {
                headers.setAccept(List.of(MediaType.parseMediaType((String)"application/json; charset=utf-8")));
            }
        };
    }

    public static Consumer<HttpHeaders> getFileUploadHeaders(Map<String, String> input) {
        return headers -> {
            String contentType = (String)input.remove("Content-Type");
            for (Map.Entry entry : input.entrySet()) {
                headers.set((String)entry.getKey(), (String)entry.getValue());
            }
            headers.setContentType(MediaType.parseMediaType((String)contentType));
        };
    }

    private static String userAgent() {
        return String.format("%s/%s; java/%s; platform/%s; processor/%s", "SpringAiAlibaba", "1.0.0", System.getProperty("java.version"), System.getProperty("os.name"), System.getProperty("os.arch"));
    }
}

