/*
 * Decompiled with CFR 0.152.
 */
package com.agenarisk.api.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class Advisory {
    private static final Map<Object, AdvisoryGroup> advisoryGroups = Collections.synchronizedMap(new HashMap());
    private static final Map<Thread, AdvisoryGroup> threadsToGroups = Collections.synchronizedMap(new HashMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AdvisoryGroup getGroupByKey(Object key) {
        Class<Advisory> clazz = Advisory.class;
        synchronized (Advisory.class) {
            if (!advisoryGroups.containsKey(key)) {
                advisoryGroups.put(key, new AdvisoryGroup(key));
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return advisoryGroups.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AdvisoryGroup getCurrentThreadGroup() {
        Class<Advisory> clazz = Advisory.class;
        synchronized (Advisory.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return threadsToGroups.get(Thread.currentThread());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AdvisoryGroup getGroupByThread(Thread thread) {
        Class<Advisory> clazz = Advisory.class;
        synchronized (Advisory.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return threadsToGroups.get(thread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroy(AdvisoryGroup aGroup) {
        Class<Advisory> clazz = Advisory.class;
        synchronized (Advisory.class) {
            aGroup.getGroupThreads().stream().collect(Collectors.toList()).forEach(thread -> aGroup.unlinkThread((Thread)thread));
            advisoryGroups.remove(aGroup.getKey());
            aGroup.getMessages().clear();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addMessageIfLinked(String message) {
        Class<Advisory> clazz = Advisory.class;
        synchronized (Advisory.class) {
            AdvisoryGroup agroup = Advisory.getCurrentThreadGroup();
            if (agroup != null) {
                agroup.addMessage(new AdvisoryMessage(message));
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return false;
        }
    }

    public static List<String> compileAdvisoryMessagesForCurrentThreadGroup() {
        return Advisory.compileAdvisoryMessages(Advisory.getCurrentThreadGroup());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> compileAdvisoryMessages(AdvisoryGroup agroup) {
        Class<Advisory> clazz = Advisory.class;
        synchronized (Advisory.class) {
            ArrayList<String> lines = new ArrayList<String>();
            if (agroup == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return lines;
            }
            agroup.getMessages().stream().forEachOrdered(amsg -> {
                if (amsg.getMessage() != null && !amsg.getMessage().trim().isEmpty()) {
                    lines.add(amsg.getMessage().trim());
                }
                Throwable cause = amsg.getCause();
                while (cause != null) {
                    if (cause.getMessage() != null && !cause.getMessage().trim().isEmpty()) {
                        lines.add(cause.getMessage().trim());
                        cause = cause.getCause();
                        continue;
                    }
                    cause = null;
                }
            });
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return lines;
        }
    }

    public static class AdvisoryGroup {
        private final Object key;
        private final Set<Thread> groupThreads = Collections.synchronizedSet(new HashSet());
        private final List<AdvisoryMessage> messages = Collections.synchronizedList(new ArrayList());

        protected AdvisoryGroup(Object key) {
            this.key = key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void linkToThread(Thread thread) {
            Class<Advisory> clazz = Advisory.class;
            synchronized (Advisory.class) {
                AdvisoryGroup aGroup = Advisory.getGroupByThread(thread);
                if (aGroup != null) {
                    throw new RuntimeException("Thread is already linked to a group with key :" + aGroup.getKey());
                }
                this.groupThreads.add(thread);
                threadsToGroups.put(thread, this);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        protected Object getKey() {
            return this.key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unlinkThread(Thread thread) {
            Class<Advisory> clazz = Advisory.class;
            synchronized (Advisory.class) {
                this.groupThreads.remove(thread);
                threadsToGroups.remove(thread);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addMessage(AdvisoryMessage message) {
            Class<Advisory> clazz = Advisory.class;
            synchronized (Advisory.class) {
                this.messages.add(message);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isLinkedTo(Thread thread) {
            Class<Advisory> clazz = Advisory.class;
            synchronized (Advisory.class) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return this.groupThreads.contains(thread);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<AdvisoryMessage> getMessages() {
            Class<Advisory> clazz = Advisory.class;
            synchronized (Advisory.class) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.messages;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set<Thread> getGroupThreads() {
            Class<Advisory> clazz = Advisory.class;
            synchronized (Advisory.class) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.groupThreads;
            }
        }
    }

    public static class AdvisoryMessage {
        private final String message;
        private final Throwable cause;

        public AdvisoryMessage(String message, Throwable cause) {
            this.message = message = (message + "").trim();
            this.cause = cause;
        }

        public AdvisoryMessage(String message) {
            this(message, null);
        }

        public String getMessage() {
            return this.message;
        }

        public Throwable getCause() {
            return this.cause;
        }
    }
}

