/*
 * Decompiled with CFR 0.152.
 */
package com.agenarisk.api.model;

import com.agenarisk.api.exception.ObservationException;
import com.agenarisk.api.model.DataSet;
import com.agenarisk.api.model.Node;
import com.agenarisk.api.model.Observation;
import org.json.JSONObject;

public class VariableObservation
extends Observation {
    private final String variableName;

    protected VariableObservation(uk.co.agena.minerva.model.scenario.Observation logicObservation, DataSet dataSet, Node node) throws ObservationException {
        super(logicObservation, dataSet, node);
        this.variableName = logicObservation.getExpressionVariableName();
        if (this.variableName == null || this.variableName.isEmpty()) {
            throw new ObservationException("Observation is not a VariableObservation");
        }
    }

    public String getVariableName() {
        return this.variableName;
    }

    @Override
    public JSONObject toJson() {
        JSONObject json = super.toJson();
        json.put(Observation.Field.constantName.toString(), (Object)this.getVariableName());
        return json;
    }

    public double getVariableValue() {
        Object valueKey = this.getEntries().keySet().stream().findFirst().orElseGet(() -> 0.0);
        if (valueKey instanceof Double) {
            return (Double)valueKey;
        }
        try {
            double value = Double.parseDouble(valueKey + "");
            return value;
        }
        catch (NumberFormatException ex) {
            return 0.0;
        }
    }
}

