/*
 * Decompiled with CFR 0.152.
 */
package com.agenarisk.api.model;

import com.agenarisk.api.exception.AgenaRiskRuntimeException;
import com.agenarisk.api.exception.StateException;
import com.agenarisk.api.model.Node;
import uk.co.agena.minerva.model.extendedbn.ContinuousIntervalEN;
import uk.co.agena.minerva.model.extendedbn.DiscreteRealEN;
import uk.co.agena.minerva.model.extendedbn.ExtendedNode;
import uk.co.agena.minerva.model.extendedbn.ExtendedState;
import uk.co.agena.minerva.model.extendedbn.ExtendedStateNotFoundException;
import uk.co.agena.minerva.model.extendedbn.IntegerIntervalEN;
import uk.co.agena.minerva.model.extendedbn.LabelledEN;
import uk.co.agena.minerva.model.extendedbn.RankedEN;
import uk.co.agena.minerva.util.model.MinervaRangeException;
import uk.co.agena.minerva.util.model.NameDescription;
import uk.co.agena.minerva.util.model.Range;

public class State {
    private final Node node;
    private ExtendedState logicState;

    private State(Node node, ExtendedState logicState) {
        this.node = node;
        this.logicState = logicState;
    }

    protected static State createState(Node node, String label) throws StateException {
        ExtendedNode en = node.getLogicNode();
        ExtendedState es = en.getExtendedStateWithName(label);
        if (es == null) {
            try {
                es = State.createLogicState(en, label);
            }
            catch (NumberFormatException ex) {
                throw new StateException("Can't parse numeric state values", ex);
            }
        }
        State state = new State(node, es);
        return state;
    }

    private static ExtendedState createLogicState(ExtendedNode en, String label) throws StateException {
        ExtendedState es = new ExtendedState();
        es.setName(new NameDescription(label, label));
        if (en instanceof ContinuousIntervalEN || en instanceof IntegerIntervalEN) {
            boolean rangeState = false;
            String[] rangeParts = null;
            if (label.contains(" - ")) {
                rangeState = true;
                rangeParts = label.split(" - ");
            }
            if (rangeState) {
                try {
                    Range r = new Range(Double.valueOf(rangeParts[0]).doubleValue(), Double.valueOf(rangeParts[1]).doubleValue());
                    es.setRange(r);
                    es.setNumericalValue(r.midPoint());
                }
                catch (MinervaRangeException ex) {
                    throw new StateException("State represents an invalid range", ex);
                }
            } else {
                es.setNumericalValue(Double.valueOf(label).doubleValue());
            }
        }
        en.addExtendedState(es, true);
        return es;
    }

    protected static State getState(Node node, String label) {
        try {
            ExtendedNode en = node.getLogicNode();
            ExtendedState es = en.getExtendedStateWithShortDesc(label);
            return new State(node, es);
        }
        catch (ExtendedStateNotFoundException ex) {
            throw new StateException("State `" + label + "` not found in node `" + node.toStringExtra() + "`", ex);
        }
    }

    public String getLabel() {
        return this.logicState.getName().getShortDescription();
    }

    public Node getNode() {
        return this.node;
    }

    public ExtendedState getLogicState() {
        return this.logicState;
    }

    public static String computeLabel(ExtendedNode en, ExtendedState es) {
        String label = en instanceof RankedEN || en instanceof LabelledEN || en instanceof DiscreteRealEN || es.getRange() == null ? es.getName().getShortDescription() : es.getRange().getLowerBound() + " - " + es.getRange().getUpperBound();
        return label;
    }

    protected void setLogicState(ExtendedState logicState) {
        String labelThat;
        ExtendedNode en = this.getNode().getLogicNode();
        String labelThis = State.computeLabel(en, this.getLogicState());
        if (!labelThis.equals(labelThat = State.computeLabel(en, logicState))) {
            throw new AgenaRiskRuntimeException("Logic state mismatch: " + labelThis + "," + labelThat);
        }
        this.logicState = logicState;
    }

    public String toString() {
        return this.getLabel();
    }

    public static enum Field {
        states,
        state;

    }
}

