/*
 * Decompiled with CFR 0.152.
 */
package com.agenarisk.api.model;

import com.agenarisk.api.model.Model;
import com.agenarisk.api.model.interfaces.Storable;
import org.json.JSONObject;

public class Settings
implements Storable {
    private final Model model;

    public static void loadSettings(Model model, JSONObject jsonSettings) {
        if (jsonSettings == null) {
            return;
        }
        uk.co.agena.minerva.model.Model logicModel = model.getLogicModel();
        Settings.loadSettings(logicModel, jsonSettings);
    }

    public static void loadSettings(uk.co.agena.minerva.model.Model logicModel, JSONObject jsonSettings) {
        if (jsonSettings == null) {
            return;
        }
        logicModel.setSimulationNoOfIterations(jsonSettings.optInt(Field.iterations.toString(), logicModel.getSimulationNoOfIterations()));
        logicModel.setSimulationEntropyConvergenceTolerance(jsonSettings.optDouble(Field.convergence.toString(), logicModel.getSimulationEntropyConvergenceTolerance()));
        logicModel.setSimulationEvidenceTolerancePercent(jsonSettings.optDouble(Field.tolerance.toString(), logicModel.getSimulationEvidenceTolerancePercent()));
        logicModel.setRankedSampleSize(jsonSettings.optInt(Field.sampleSizeRanked.toString(), logicModel.getRankedSampleSize()));
        logicModel.setSimulationTails(jsonSettings.optBoolean(Field.discreteTails.toString(), logicModel.isSimulationTails()));
        logicModel.setSimulationLogging(jsonSettings.optBoolean(Field.simulationLogging.toString(), logicModel.isSimulationLogging()));
        logicModel.setEMLogging(jsonSettings.optBoolean(Field.parameterLearningLogging.toString(), logicModel.isEMLogging()));
    }

    public static JSONObject toJson(uk.co.agena.minerva.model.Model model) {
        JSONObject jsonSettings = new JSONObject();
        jsonSettings.put(Field.iterations.toString(), model.getSimulationNoOfIterations());
        jsonSettings.put(Field.convergence.toString(), model.getSimulationEntropyConvergenceTolerance());
        jsonSettings.put(Field.tolerance.toString(), model.getSimulationEvidenceTolerancePercent());
        jsonSettings.put(Field.sampleSizeRanked.toString(), model.getRankedSampleSize());
        jsonSettings.put(Field.discreteTails.toString(), model.isSimulationTails());
        jsonSettings.put(Field.simulationLogging.toString(), model.isSimulationLogging());
        jsonSettings.put(Field.parameterLearningLogging.toString(), model.isEMLogging());
        return jsonSettings;
    }

    protected Settings(Model model) {
        this.model = model;
    }

    public int getIterations() {
        return this.model.getLogicModel().getSimulationNoOfIterations();
    }

    public void setIterations(int iterations) {
        this.model.getLogicModel().setSimulationNoOfIterations(iterations);
    }

    public double getConvergence() {
        return this.model.getLogicModel().getSimulationEntropyConvergenceTolerance();
    }

    public void setConvergence(double convergence) {
        this.model.getLogicModel().setSimulationEntropyConvergenceTolerance(convergence);
    }

    public double getTolerance() {
        return this.model.getLogicModel().getSimulationEvidenceTolerancePercent();
    }

    public void setTolerance(double tolerance) {
        this.model.getLogicModel().setSimulationEvidenceTolerancePercent(tolerance);
    }

    public int getSampleSize() {
        return this.model.getLogicModel().getRankedSampleSize();
    }

    public void setSampleSize(int sampleSize) {
        this.model.getLogicModel().setRankedSampleSize(sampleSize);
    }

    public boolean isDiscretizeTails() {
        return this.model.getLogicModel().isSimulationTails();
    }

    public void setDiscretizeTails(boolean discretizeTails) {
        this.model.getLogicModel().setSimulationTails(discretizeTails);
    }

    @Override
    public JSONObject toJson() {
        return Settings.toJson(this.model.getLogicModel());
    }

    public void fromJson(JSONObject jsonSettings) {
        Settings.loadSettings(this.model, jsonSettings);
    }

    public static enum Field {
        settings,
        iterations,
        convergence,
        tolerance,
        sampleSizeRanked,
        discreteTails,
        simulationLogging,
        parameterLearningLogging;

    }
}

