/*
 * Decompiled with CFR 0.152.
 */
package com.agenarisk.api.model;

import com.agenarisk.api.exception.ObservationException;
import com.agenarisk.api.model.DataSet;
import com.agenarisk.api.model.Node;
import com.agenarisk.api.model.interfaces.Storable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import uk.co.agena.minerva.model.extendedbn.DiscreteRealEN;
import uk.co.agena.minerva.model.extendedbn.ExtendedNode;
import uk.co.agena.minerva.model.extendedbn.ExtendedState;
import uk.co.agena.minerva.model.extendedbn.ExtendedStateNotFoundException;
import uk.co.agena.minerva.model.extendedbn.LabelledEN;
import uk.co.agena.minerva.model.extendedbn.RankedEN;
import uk.co.agena.minerva.util.Logger;
import uk.co.agena.minerva.util.model.DataPoint;

public class Observation
implements Storable {
    private final DataSet dataSet;
    private final Node node;
    private final Map<Object, Double> entries;
    private final uk.co.agena.minerva.model.scenario.Observation logicObservation;

    protected Observation(uk.co.agena.minerva.model.scenario.Observation logicObservation, DataSet dataSet, Node node) throws ObservationException {
        this.node = node;
        this.dataSet = dataSet;
        this.logicObservation = logicObservation;
        this.entries = this.compileEntriesMap();
        if (this.entries == null || this.entries.isEmpty()) {
            throw new ObservationException("Empty observation is not allowed");
        }
    }

    public Map<Object, Double> getEntries() {
        return this.entries;
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public Node getNode() {
        return this.node;
    }

    public uk.co.agena.minerva.model.scenario.Observation getLogicObservation() {
        return this.logicObservation;
    }

    private Map<Object, Double> compileEntriesMap() {
        LinkedHashMap<Object, Double> map = new LinkedHashMap<Object, Double>();
        switch (this.node.getType()) {
            case ContinuousInterval: {
                map.put(Double.valueOf(this.logicObservation.getUserEnteredAnswer()), 1.0);
                break;
            }
            case IntegerInterval: {
                map.put(Double.valueOf(this.logicObservation.getUserEnteredAnswer()).intValue(), 1.0);
                break;
            }
            default: {
                List dps = this.logicObservation.getDataSet().getDataPoints();
                for (DataPoint dp : dps) {
                    String key = this.logicObservation.getUserEnteredAnswer();
                    ExtendedState es = null;
                    try {
                        es = this.node.getLogicNode().getExtendedState(dp.getConnObjectId());
                    }
                    catch (ExtendedStateNotFoundException ex) {
                        Logger.printThrowableIfDebug((Throwable)ex);
                    }
                    if (es != null) {
                        key = es.getName().getShortDescription();
                    }
                    map.put(key, dp.getValue());
                }
            }
        }
        return map;
    }

    public String toString() {
        return this.toJson().toString();
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonObservation = new JSONObject();
        jsonObservation.put(Field.network.toString(), (Object)this.node.getNetwork().getId());
        jsonObservation.put(Field.node.toString(), (Object)this.node.getId());
        if (!this.logicObservation.getExpressionVariableName().isEmpty()) {
            jsonObservation.put(Field.constantName.toString(), (Object)this.logicObservation.getExpressionVariableName());
        }
        JSONArray jsonEntries = new JSONArray();
        ExtendedNode en = this.node.getLogicNode();
        if (en instanceof RankedEN || en instanceof LabelledEN || en instanceof DiscreteRealEN) {
            for (DataPoint dp : this.logicObservation.getDataSet().getDataPoints()) {
                JSONObject jsonEntry = new JSONObject();
                String value = this.logicObservation.getUserEnteredAnswer();
                ExtendedState es = null;
                try {
                    es = en.getExtendedState(dp.getConnObjectId());
                }
                catch (ExtendedStateNotFoundException extendedStateNotFoundException) {
                    // empty catch block
                }
                if (es != null) {
                    value = es.getName().getShortDescription();
                }
                jsonEntry.put(Field.value.toString(), (Object)value);
                jsonEntry.put(Field.weight.toString(), dp.getValue());
                jsonEntries.put((Object)jsonEntry);
            }
        } else {
            JSONObject jsonEntry = new JSONObject();
            String observationAnswer = this.logicObservation.getUserEnteredAnswer();
            jsonEntry.put(Field.value.toString(), (Object)observationAnswer);
            jsonEntry.put(Field.weight.toString(), 1);
            jsonEntries.put((Object)jsonEntry);
        }
        jsonObservation.put(Field.entries.toString(), (Object)jsonEntries);
        return jsonObservation;
    }

    public static enum Field {
        observations,
        observation,
        network,
        node,
        constantName,
        entries,
        entry,
        value,
        weight;

    }
}

