/*
 * Decompiled with CFR 0.152.
 */
package com.agenarisk.api.io;

import com.agenarisk.api.exception.AdapterException;
import com.agenarisk.api.io.stub.Audit;
import com.agenarisk.api.io.stub.Graphics;
import com.agenarisk.api.io.stub.Meta;
import com.agenarisk.api.io.stub.RiskTable;
import com.agenarisk.api.model.CalculationResult;
import com.agenarisk.api.model.DataSet;
import com.agenarisk.api.model.Link;
import com.agenarisk.api.model.Network;
import com.agenarisk.api.model.Node;
import com.agenarisk.api.model.NodeConfiguration;
import com.agenarisk.api.model.Observation;
import com.agenarisk.api.model.ResultValue;
import com.agenarisk.api.model.State;
import com.agenarisk.api.util.JSONUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.XML;

public class XMLAdapter {
    private static final Map<String, String> WRAPPER_MAP = new HashMap<String, String>();

    public static JSONObject xmlToJson(String xmlString) throws AdapterException {
        JSONObject json;
        try {
            json = XML.toJSONObject((String)xmlString);
            XMLAdapter.convertXmlJson(json);
        }
        catch (JSONException ex) {
            throw new AdapterException("Failed to convert model XML to JSON", ex);
        }
        return json;
    }

    public static String toXMLString(Object o) {
        return XMLAdapter.toXMLString(o, null);
    }

    private static String toXMLString(Object o, String wrapper) {
        StringBuilder sb = new StringBuilder();
        String prefix = "";
        String suffix = "";
        if (o instanceof String && prefix.isEmpty() && suffix.isEmpty()) {
            wrapper = "CDATA";
        }
        if (wrapper != null) {
            if (wrapper.equals("CDATA")) {
                prefix = "<![CDATA[";
                suffix = "]]>";
            } else {
                List<String> wrappers = Arrays.asList(wrapper.split(","));
                prefix = wrappers.stream().map(w -> "<" + w + ">").collect(Collectors.joining(""));
                Collections.reverse(wrappers);
                suffix = wrappers.stream().map(w -> "</" + w + ">").collect(Collectors.joining(""));
            }
        }
        if (o instanceof JSONObject) {
            if (!prefix.isEmpty()) {
                sb.append(prefix);
            }
            JSONObject jo = (JSONObject)o;
            Iterator keys = jo.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                sb.append("<").append(key).append(">");
                String wrapperNext = WRAPPER_MAP.get(key);
                sb.append(XMLAdapter.toXMLString(jo.opt(key), wrapperNext));
                sb.append("</").append(key).append(">");
            }
            if (!suffix.isEmpty()) {
                sb.append(suffix);
            }
        } else if (o instanceof JSONArray) {
            JSONArray ja = (JSONArray)o;
            for (int i = 0; i < ja.length(); ++i) {
                if (!prefix.isEmpty()) {
                    sb.append(prefix);
                }
                String wrapperNext = WRAPPER_MAP.get(wrapper);
                sb.append(XMLAdapter.toXMLString(ja.opt(i), wrapperNext));
                if (suffix.isEmpty()) continue;
                sb.append(suffix);
            }
        } else {
            if (!prefix.isEmpty()) {
                sb.append(prefix);
            }
            sb.append(o);
            if (!suffix.isEmpty()) {
                sb.append(suffix);
            }
        }
        return sb.toString();
    }

    private static void convertXmlJson(Object o) throws JSONException, AdapterException {
        block12: {
            block11: {
                if (!(o instanceof JSONObject)) break block11;
                JSONObject jo = (JSONObject)o;
                Iterator keys = jo.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    String wrapper = WRAPPER_MAP.get(key);
                    if (NodeConfiguration.Table.probabilities.toString().equals(key)) {
                        boolean columns = false;
                        boolean rows = false;
                        JSONObject jTable = jo.optJSONObject(NodeConfiguration.Table.probabilities.toString());
                        try {
                            columns = jTable.has(NodeConfiguration.Table.column.toString());
                            rows = jTable.has(NodeConfiguration.Table.row.toString());
                        }
                        catch (NullPointerException nullPointerException) {
                            // empty catch block
                        }
                        if (rows && columns) {
                            throw new AdapterException("Node table can contain either rows or columns, but not both");
                        }
                        String groupKey = "";
                        if (columns) {
                            groupKey = NodeConfiguration.Table.column.toString();
                            jo.put(NodeConfiguration.Table.pvalues.toString(), (Object)groupKey);
                        } else {
                            groupKey = NodeConfiguration.Table.row.toString();
                        }
                        if (rows || columns) {
                            JSONUtils.convertToJSONArray(jo, key, groupKey);
                            JSONUtils.convertTo2DArray(jo, key, NodeConfiguration.Table.cell.toString());
                        }
                    } else if (wrapper != null && !wrapper.equals("CDATA")) {
                        JSONUtils.convertToJSONArray(jo, key, wrapper);
                    }
                    XMLAdapter.convertXmlJson(jo.opt(key));
                }
                break block12;
            }
            if (!(o instanceof JSONArray)) break block12;
            JSONArray ja = (JSONArray)o;
            for (int i = 0; i < ja.length(); ++i) {
                XMLAdapter.convertXmlJson(ja.opt(i));
            }
        }
    }

    static {
        WRAPPER_MAP.put(Network.Field.networks.toString(), Network.Field.network.toString());
        WRAPPER_MAP.put(Network.ModificationLog.modificationLog.toString(), Network.ModificationLog.entry.toString());
        WRAPPER_MAP.put(Node.Field.nodes.toString(), Node.Field.node.toString());
        WRAPPER_MAP.put(State.Field.states.toString(), State.Field.state.toString());
        WRAPPER_MAP.put(NodeConfiguration.Table.expressions.toString(), NodeConfiguration.Table.expression.toString());
        WRAPPER_MAP.put(NodeConfiguration.Table.partitions.toString(), NodeConfiguration.Table.partition.toString());
        WRAPPER_MAP.put(NodeConfiguration.Variables.variables.toString(), NodeConfiguration.Variables.variable.toString());
        WRAPPER_MAP.put(Link.Field.links.toString(), Link.Field.link.toString());
        WRAPPER_MAP.put(DataSet.Field.dataSets.toString(), DataSet.Field.dataSet.toString());
        WRAPPER_MAP.put(CalculationResult.Field.results.toString(), CalculationResult.Field.result.toString());
        WRAPPER_MAP.put(ResultValue.Field.resultValues.toString(), ResultValue.Field.resultValue.toString());
        WRAPPER_MAP.put(Observation.Field.entries.toString(), Observation.Field.entry.toString());
        WRAPPER_MAP.put(Observation.Field.observations.toString(), Observation.Field.observation.toString());
        WRAPPER_MAP.put(RiskTable.Field.riskTable.toString(), RiskTable.Field.questionnaire.toString());
        WRAPPER_MAP.put(RiskTable.Question.questions.toString(), RiskTable.Question.question.toString());
        WRAPPER_MAP.put(RiskTable.Answer.answers.toString(), RiskTable.Answer.answer.toString());
        WRAPPER_MAP.put(Meta.Field.notes.toString(), Meta.Field.note.toString());
        WRAPPER_MAP.put(Audit.Field.changelog.toString(), Audit.Field.change.toString());
        WRAPPER_MAP.put(Graphics.CanvasData.canvasData.toString(), Graphics.CanvasData.canvas.toString());
        WRAPPER_MAP.put(Network.Field.description.toString(), "CDATA");
        WRAPPER_MAP.put(Node.Field.description.toString(), "CDATA");
        WRAPPER_MAP.put(NodeConfiguration.Table.expression.toString(), "CDATA");
        WRAPPER_MAP.put(Meta.Field.text.toString(), "CDATA");
        WRAPPER_MAP.put(Graphics.Field.viewSettings.toString(), "CDATA");
        WRAPPER_MAP.put(Graphics.Field.objectDefaults.toString(), "CDATA");
        WRAPPER_MAP.put(Graphics.Field.openMonitors.toString(), "CDATA");
        WRAPPER_MAP.put(Graphics.CanvasData.canvas.toString(), "CDATA");
        WRAPPER_MAP.put(Audit.Field.comment.toString(), "CDATA");
        WRAPPER_MAP.put(NodeConfiguration.Table.probabilities.toString(), "row");
        WRAPPER_MAP.put("row", "cell");
    }
}

