/*
 * Decompiled with CFR 0.152.
 */
package com.agenarisk.api.io;

import com.agenarisk.api.exception.AdapterException;
import com.agenarisk.api.io.XMLAdapter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.json.JSONObject;

public class FileAdapter {
    public static JSONObject extractJSONObject(String filePath) throws AdapterException {
        String fileContents;
        filePath = filePath.replaceFirst("^[\"'](.*)[\"']$", "$1");
        JSONObject json = null;
        try {
            fileContents = new String(Files.readAllBytes(Paths.get(filePath, new String[0]))).trim();
        }
        catch (IOException ex) {
            throw new AdapterException("Failed to read file", ex);
        }
        if (fileContents.startsWith("{")) {
            json = new JSONObject(fileContents);
        } else if (fileContents.startsWith("<")) {
            json = XMLAdapter.xmlToJson(fileContents);
        }
        return json;
    }
}

