/*
 * Decompiled with CFR 0.152.
 */
package com.agenarisk.api.util;

import com.agenarisk.api.exception.AgenaRiskRuntimeException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONUtils {
    public static JSONObject toJSONObject(Object[][] array) {
        return new JSONObject(Arrays.stream(array).collect(Collectors.toMap(kv -> kv[0].toString(), kv -> kv[1])));
    }

    public static String createMissingAttrMessage(JSONException ex) {
        if (ex.getMessage() == null) {
            return "JSON missing a required attribute";
        }
        if (ex.getMessage().contains("JSONObject[")) {
            return "JSON missing required attribute: " + ex.getMessage().replaceFirst("JSONObject\\[\"(.*)\"\\] not found.", "$1");
        }
        return "JSON missing required attribute at index: " + ex.getMessage().replaceFirst("JSONArray\\[(.*)\\] not found.", "$1");
    }

    public static <T> List<T> toList(JSONArray jarray, Class<T> classType) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < jarray.length(); ++i) {
            Object item = jarray.opt(i);
            if (item == null) continue;
            list.add(item);
        }
        return list;
    }

    public static void convertTo2DArray(JSONObject grandParent, String parentKey, String elementKey) throws JSONException {
        JSONArray arrayOld = grandParent.getJSONArray(parentKey);
        for (int r = 0; r < arrayOld.length(); ++r) {
            JSONObject itemLevel1 = arrayOld.getJSONObject(r);
            Object itemLevel2 = itemLevel1.get(elementKey);
            if (!(itemLevel2 instanceof JSONArray)) {
                JSONArray itemLevel1New = new JSONArray();
                itemLevel1New.put(itemLevel2);
                arrayOld.put(r, (Object)itemLevel1New);
                continue;
            }
            arrayOld.put(r, itemLevel2);
        }
    }

    public static void convertToJSONArray(JSONObject grandParent, String parentKey, String childKey) throws JSONException {
        Object jsonChildObject;
        JSONArray jsonArray = new JSONArray();
        if (!grandParent.has(parentKey)) {
            grandParent.put(parentKey, (Object)new JSONArray());
            return;
        }
        Object jsonParentObject = grandParent.get(parentKey);
        if (jsonParentObject instanceof JSONObject) {
            jsonChildObject = ((JSONObject)jsonParentObject).get(childKey);
        } else if (jsonParentObject instanceof JSONArray) {
            jsonChildObject = ((JSONArray)jsonParentObject).getJSONObject(0).get(childKey);
        } else {
            if (jsonParentObject instanceof String) {
                grandParent.put(parentKey, (Object)new JSONArray());
                return;
            }
            throw new JSONException("Wrong object type for `" + parentKey + "`.`" + childKey + "`");
        }
        if (jsonChildObject instanceof JSONArray) {
            jsonArray = (JSONArray)jsonChildObject;
        } else {
            jsonArray.put(jsonChildObject);
        }
        grandParent.put(parentKey, (Object)jsonArray);
    }

    public static void wrapArrayElements(JSONArray parent, String wrapperName) {
        for (int i = 0; i < parent.length(); ++i) {
            Object o = parent.opt(i);
            JSONObject wrapper = new JSONObject();
            try {
                wrapper.put(wrapperName, o);
                parent.put(i, (Object)wrapper);
                continue;
            }
            catch (JSONException ex) {
                throw new AgenaRiskRuntimeException("Failed to wrap elements", ex);
            }
        }
    }

    public static boolean equalsIgnoreCase(JSONObject jo1, JSONObject jo2) {
        if (jo1 == null && jo2 == null) {
            return true;
        }
        if (jo1 == null && jo2 != null || jo1 != null && jo2 == null) {
            return false;
        }
        if (jo1.length() != jo2.length()) {
            return false;
        }
        Iterator keys = jo1.keys();
        while (keys.hasNext()) {
            Object el2;
            String key = (String)keys.next();
            if (!jo2.has(key)) {
                return false;
            }
            Object el1 = jo1.opt(key);
            boolean equals = JSONUtils.equalsJSONComponents(el1, el2 = jo2.opt(key));
            if (equals) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsIgnoreCase(JSONArray ja1, JSONArray ja2) {
        if (ja1 == null && ja2 == null) {
            return true;
        }
        if (ja1 == null && ja2 != null || ja1 != null && ja2 == null) {
            return false;
        }
        if (ja1.length() != ja2.length()) {
            return false;
        }
        for (int i = 0; i < ja1.length(); ++i) {
            Object el2;
            Object el1 = ja1.opt(i);
            boolean equals = JSONUtils.equalsJSONComponents(el1, el2 = ja2.opt(i));
            if (equals) continue;
            return false;
        }
        return true;
    }

    private static boolean equalsJSONComponents(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null && o2 != null || o1 != null && o2 == null) {
            return false;
        }
        if (!o1.getClass().getName().equalsIgnoreCase(o2.getClass().getName())) {
            return false;
        }
        if (o1 instanceof JSONObject) {
            return JSONUtils.equalsIgnoreCase((JSONObject)o1, (JSONObject)o2);
        }
        if (o1 instanceof JSONArray) {
            return JSONUtils.equalsIgnoreCase((JSONArray)o1, (JSONArray)o2);
        }
        if (o1 instanceof String) {
            String s1 = (String)o1;
            String s2 = (String)o2;
            String numberPattern = "-?[\\d]+(\\.[\\d]+)?";
            if (s1.matches(numberPattern)) {
                s1 = s1.replaceFirst("\\.0$", "");
            }
            if (s2.matches(numberPattern)) {
                s2 = s2.replaceFirst("\\.0$", "");
            }
            boolean comparison = s1.equalsIgnoreCase(s2);
            return comparison;
        }
        if (o1 instanceof Double) {
            DecimalFormat df = new DecimalFormat("#.#######");
            o1 = df.format(o1);
            o2 = df.format(o2);
            boolean comparison = o1.equals(o2);
            return comparison;
        }
        return o1.equals(o2);
    }

    public static JSONObject getnnJObject(JSONArray parent, int index) {
        JSONObject jObject = parent.optJSONObject(index);
        if (jObject == null) {
            jObject = new JSONObject();
        }
        return jObject;
    }

    public static JSONObject getNNJObject(JSONObject parent, Object key) {
        JSONObject jObject = parent.optJSONObject(key + "");
        if (jObject == null) {
            jObject = new JSONObject();
        }
        return jObject;
    }

    public static JSONArray getNNJArray(JSONObject parent, Object key) {
        JSONArray jArray = parent.optJSONArray(key + "");
        if (jArray == null) {
            jArray = new JSONArray();
        }
        return jArray;
    }

    public static JSONArray getNNJArray(JSONArray parent, int index) {
        JSONArray jArray = parent.optJSONArray(index);
        if (jArray == null) {
            jArray = new JSONArray();
        }
        return jArray;
    }

    public static void traverse(Object o, Consumer<Object> action) {
        block3: {
            block2: {
                action.accept(o);
                if (!(o instanceof JSONObject)) break block2;
                JSONObject jo = (JSONObject)o;
                Iterator keys = jo.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    JSONUtils.traverse(jo.opt(key), action);
                }
                break block3;
            }
            if (!(o instanceof JSONArray)) break block3;
            JSONArray ja = (JSONArray)o;
            for (int i = 0; i < ja.length(); ++i) {
                JSONUtils.traverse(ja.opt(i), action);
            }
        }
    }
}

