/*
 * Decompiled with CFR 0.152.
 */
package com.agenarisk.api.model;

import com.agenarisk.api.exception.AgenaRiskRuntimeException;
import com.agenarisk.api.exception.LinkException;
import com.agenarisk.api.exception.NetworkException;
import com.agenarisk.api.exception.NodeException;
import com.agenarisk.api.io.JSONAdapter;
import com.agenarisk.api.io.stub.Graphics;
import com.agenarisk.api.io.stub.Meta;
import com.agenarisk.api.io.stub.NodeGraphics;
import com.agenarisk.api.model.CrossNetworkLink;
import com.agenarisk.api.model.DataSet;
import com.agenarisk.api.model.Link;
import com.agenarisk.api.model.Model;
import com.agenarisk.api.model.Network;
import com.agenarisk.api.model.NodeConfiguration;
import com.agenarisk.api.model.State;
import com.agenarisk.api.model.Variable;
import com.agenarisk.api.model.VariableObservation;
import com.agenarisk.api.model.field.Id;
import com.agenarisk.api.model.interfaces.Identifiable;
import com.agenarisk.api.model.interfaces.Named;
import com.agenarisk.api.model.interfaces.Networked;
import com.agenarisk.api.model.interfaces.Storable;
import com.agenarisk.api.util.Advisory;
import com.agenarisk.api.util.JSONUtils;
import com.singularsys.jep.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import uk.co.agena.minerva.model.MarginalDataItemList;
import uk.co.agena.minerva.model.corebn.CoreBNNodeNotFoundException;
import uk.co.agena.minerva.model.extendedbn.ContinuousEN;
import uk.co.agena.minerva.model.extendedbn.ExtendedBN;
import uk.co.agena.minerva.model.extendedbn.ExtendedBNException;
import uk.co.agena.minerva.model.extendedbn.ExtendedNode;
import uk.co.agena.minerva.model.extendedbn.ExtendedNodeFunction;
import uk.co.agena.minerva.model.extendedbn.ExtendedStateException;
import uk.co.agena.minerva.model.extendedbn.ExtendedStateNumberingException;
import uk.co.agena.minerva.model.extendedbn.NumericalEN;
import uk.co.agena.minerva.model.extendedbn.RankedEN;
import uk.co.agena.minerva.model.scenario.Scenario;
import uk.co.agena.minerva.util.Logger;
import uk.co.agena.minerva.util.helpers.MathsHelper;
import uk.co.agena.minerva.util.model.DataPoint;
import uk.co.agena.minerva.util.model.IntervalDataPoint;
import uk.co.agena.minerva.util.model.MinervaRangeException;
import uk.co.agena.minerva.util.model.MinervaVariableException;
import uk.co.agena.minerva.util.model.NameDescription;
import uk.co.agena.minerva.util.model.Range;
import uk.co.agena.minerva.util.model.VariableList;
import uk.co.agena.minerva.util.nptgenerator.ExpressionParser;

public class Node
implements Networked<Node>,
Comparable<Node>,
Identifiable<NodeException>,
Storable,
Named {
    private final Network network;
    private final Set<Link> linksIn = Collections.synchronizedSet(new LinkedHashSet());
    private final Set<Link> linksOut = Collections.synchronizedSet(new LinkedHashSet());
    private ExtendedNode logicNode;
    private JSONObject jsonMeta;
    private JSONObject jsonGraphics;
    private final Map<String, Variable> variablesCache = Collections.synchronizedMap(new LinkedHashMap());

    private Node(Network network, String id, String name, Type type) {
        ExtendedNode en;
        String nodeClassName = NodeConfiguration.resolveNodeClassName(type);
        try {
            en = network.getLogicNetwork().createNewExtendedNode(nodeClassName, new NameDescription(name, ""));
            network.getLogicNetwork().updateConnNodeId(en, id);
        }
        catch (CoreBNNodeNotFoundException | ExtendedBNException ex) {
            throw new AgenaRiskRuntimeException("Failed to create a node for ID `" + id + "`", ex);
        }
        this.network = network;
        this.logicNode = en;
        this.createDefaultStates();
    }

    @Override
    public synchronized List<Link> getLinksIn() {
        return Collections.unmodifiableList(new ArrayList<Link>(this.linksIn));
    }

    @Override
    public synchronized List<Link> getLinksOut() {
        return Collections.unmodifiableList(new ArrayList<Link>(this.linksOut));
    }

    @Override
    public synchronized Set<Node> getParents() {
        return this.getLinksIn().stream().map(link -> link.getFromNode()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    public synchronized Set<Node> getChildren() {
        return this.getLinksOut().stream().map(link -> link.getToNode()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    protected final boolean addLink(Link link) {
        if (link.getFromNode().equals(this)) {
            this.linksOut.add(link);
            return true;
        }
        if (link.getToNode().equals(this)) {
            this.linksIn.add(link);
            return true;
        }
        return false;
    }

    protected final boolean removeLink(Link link) {
        if (link.getFromNode().equals(this)) {
            this.linksOut.remove(link);
            return true;
        }
        if (link.getToNode().equals(this)) {
            this.linksIn.remove(link);
            return true;
        }
        return false;
    }

    public synchronized Link linkTo(Node child) throws LinkException {
        return Node.linkNodes(this, child);
    }

    public synchronized Link linkFrom(Node parent) throws LinkException {
        return Node.linkNodes(parent, this);
    }

    public static boolean unlinkNodes(Node node1, Node node2) {
        List<Link> links = node1.getLinksIn();
        links.addAll(node1.getLinksOut());
        Link link = null;
        for (Link l : links) {
            if ((!l.getFromNode().equals(node1) || !l.getToNode().equals(node2)) && (!l.getFromNode().equals(node2) || !l.getToNode().equals(node1))) continue;
            link = l;
        }
        if (link == null) {
            return false;
        }
        node1.removeLink(link);
        node2.removeLink(link);
        link.destroyLogicLink();
        return true;
    }

    public static void linkNodes(Model model, JSONArray jsonLinks) throws JSONException, LinkException, NodeException {
        if (jsonLinks == null) {
            return;
        }
        for (int i = 0; i < jsonLinks.length(); ++i) {
            Node targetNode;
            Node sourceNode;
            JSONObject jsonLink = jsonLinks.getJSONObject(i);
            String net1Id = jsonLink.getString(CrossNetworkLink.Field.sourceNetwork.toString());
            String node1Id = jsonLink.getString(CrossNetworkLink.Field.sourceNode.toString());
            String net2Id = jsonLink.getString(CrossNetworkLink.Field.targetNetwork.toString());
            String node2Id = jsonLink.getString(CrossNetworkLink.Field.targetNode.toString());
            try {
                sourceNode = model.getNetwork(net1Id).getNode(node1Id);
                sourceNode.getId();
                targetNode = model.getNetwork(net2Id).getNode(node2Id);
                targetNode.getId();
            }
            catch (NullPointerException ex) {
                throw new LinkException("Network or node not found", ex);
            }
            CrossNetworkLink.Type linkType = CrossNetworkLink.Type.Marginals;
            try {
                String linkTypeString = jsonLink.getString(CrossNetworkLink.Field.type.toString());
                try {
                    linkType = CrossNetworkLink.Type.valueOf(linkTypeString);
                }
                catch (IllegalArgumentException ex) {
                    throw new LinkException("Invalid link type `" + linkTypeString + "`", ex);
                }
            }
            catch (JSONException ex) {
                Logger.logIfDebug((Object)"No cross network link type provided, defaulting to type = Marginals");
            }
            String stateId = jsonLink.optString(CrossNetworkLink.Field.passState.toString(), null);
            try {
                Node.linkNodes(sourceNode, targetNode, linkType, stateId);
                continue;
            }
            catch (LinkException ex) {
                throw new NodeException("Failed to create a link between nodes " + sourceNode + " and " + targetNode, ex);
            }
        }
    }

    public static Link linkNodes(Node fromNode, Node toNode) throws LinkException {
        return Node.linkNodes(fromNode, toNode, null, null);
    }

    public static Link linkNodes(Node fromNode, Node toNode, CrossNetworkLink.Type type) throws LinkException {
        return Node.linkNodes(fromNode, toNode, type, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Link linkNodes(Node fromNode, Node toNode, CrossNetworkLink.Type type, String stateToPass) throws LinkException {
        Class<Network> clazz = Network.class;
        synchronized (Network.class) {
            Link link;
            boolean crossNetworkLink;
            if (fromNode.getChildren().contains(toNode)) {
                throw new LinkException("Link already exists");
            }
            if (Objects.equals(fromNode, toNode)) {
                throw new LinkException("Trying to link node to itself");
            }
            boolean bl = crossNetworkLink = !Objects.equals(fromNode.getNetwork(), toNode.getNetwork());
            if (toNode.isConnectedInput()) {
                throw new LinkException("Node " + fromNode.toStringExtra() + " already has an incoming cross network link");
            }
            if (crossNetworkLink) {
                if (!toNode.getLinksIn().isEmpty()) {
                    throw new LinkException("Can't add a cross network link to " + toNode.toStringExtra() + " because it already has parents");
                }
                if (toNode.getLogicNode().isConnectableOutputNode() && !toNode.getLinksOut().isEmpty()) {
                    throw new LinkException("Node " + toNode.toStringExtra() + " already appears to be configured for cross network outgoing link");
                }
                if (fromNode.getLogicNode().isConnectableInputNode() && !toNode.getLinksIn().isEmpty()) {
                    throw new LinkException("Node " + fromNode.toStringExtra() + " already appears to be configured for cross network incoming link");
                }
                if (!(Objects.equals((Object)fromNode.getType(), (Object)toNode.getType()) && (fromNode.isSimulated() || toNode.isSimulated()) || Objects.equals((Object)fromNode.getType(), (Object)toNode.getType()) && !fromNode.isSimulated() && !toNode.isSimulated() && fromNode.getStates().size() == toNode.getStates().size() || !Arrays.asList(Type.ContinuousInterval, Type.IntegerInterval, Type.DiscreteReal).contains((Object)fromNode.getType()) && toNode.isSimulated())) {
                    throw new LinkException("Cross network link not allowed between nodes (" + fromNode.toStringExtra() + " is " + (Object)((Object)fromNode.getType()) + ", " + toNode.toStringExtra() + " is " + (Object)((Object)toNode.getType()) + "), see documentation");
                }
                if (!fromNode.isSimulated() && !toNode.isSimulated() && fromNode.getLogicNode().getExtendedStates().size() != toNode.getLogicNode().getExtendedStates().size()) {
                    throw new LinkException("Cross network link can only be created between nodes with the same number of states");
                }
                link = CrossNetworkLink.createCrossNetworkLink(fromNode, toNode, type, stateToPass);
            } else {
                if (fromNode.getChildren().contains(toNode)) {
                    throw new LinkException("A link between " + fromNode.toStringExtra() + " and " + toNode.toStringExtra() + " already exists");
                }
                link = Link.createLink(fromNode, toNode);
            }
            fromNode.addLink(link);
            if (type == null) {
                if (fromNode.hasDescendant(fromNode)) {
                    fromNode.removeLink(link);
                    throw new LinkException("This link would create a loop in the network");
                }
            } else if (fromNode.getNetwork().hasDescendant(fromNode.getNetwork())) {
                fromNode.removeLink(link);
                throw new LinkException("This link would create a loop between networks");
            }
            toNode.addLink(link);
            try {
                link.createLogicLink();
            }
            catch (LinkException ex) {
                fromNode.removeLink(link);
                toNode.removeLink(link);
                throw ex;
            }
            return link;
        }
    }

    protected static Node createNode(Network network, String id, String name, Type type) {
        return new Node(network, id, name, type);
    }

    protected static Node createNode(Network network, JSONObject jsonNode) throws NodeException, JSONException {
        return Node.createNode(network, jsonNode, true);
    }

    protected static Node createNode(Network network, JSONObject jsonNode, boolean withTables) throws NodeException, JSONException {
        Node node;
        JSONObject jsonConfiguration;
        String id = jsonNode.getString(Field.id.toString());
        String name = jsonNode.optString(Field.name.toString());
        String description = jsonNode.optString(Field.description.toString());
        if (name.isEmpty()) {
            name = id;
        }
        if ((jsonConfiguration = jsonNode.optJSONObject(NodeConfiguration.Field.configuration.toString())) == null) {
            jsonConfiguration = new JSONObject();
        }
        String typeString = jsonConfiguration.optString(NodeConfiguration.Field.type.toString(), Type.Boolean.toString());
        Type type = Type.valueOf(typeString);
        try {
            node = network.createNode(id, name, type);
            node.setDescription(description);
        }
        catch (NetworkException ex) {
            throw new NodeException("Failed to add a node to network", ex);
        }
        ExtendedNode en = node.getLogicNode();
        boolean simulated = jsonConfiguration.optBoolean(NodeConfiguration.Field.simulated.toString(), false);
        if (simulated) {
            ContinuousEN cien = (ContinuousEN)en;
            NodeConfiguration.setDefaultIntervalStates(node);
            cien.setSimulationNode(true);
            if (jsonConfiguration.has(NodeConfiguration.Field.simulationConvergence.toString())) {
                cien.setEntropyConvergenceThreshold(jsonConfiguration.getDouble(NodeConfiguration.Field.simulationConvergence.toString()));
            }
        } else {
            node.setStates(jsonConfiguration.optJSONArray(State.Field.states.toString()));
        }
        if (jsonConfiguration.optBoolean(NodeConfiguration.Field.output.toString(), false)) {
            en.setConnectableOutputNode(true);
        }
        try {
            if (jsonConfiguration.optBoolean(NodeConfiguration.Field.input.toString(), false)) {
                en.setConnectableInputNode(true);
            }
        }
        catch (ExtendedBNException ex) {
            throw new NodeException("Can't mark node as input node", ex);
        }
        JSONArray jsonVariables = jsonConfiguration.optJSONArray(NodeConfiguration.Variables.variables.toString());
        if (jsonVariables != null) {
            for (int i = 0; i < jsonVariables.length(); ++i) {
                JSONObject jsonVariable = jsonVariables.getJSONObject(i);
                String variableName = "";
                try {
                    Double variableValue;
                    try {
                        variableName = jsonVariable.getString(NodeConfiguration.Variables.name.toString());
                        variableValue = jsonVariable.getDouble(NodeConfiguration.Variables.value.toString());
                    }
                    catch (JSONException ex) {
                        throw new NodeException(ex.getMessage(), ex);
                    }
                    node.createVariable(variableName, variableValue);
                    continue;
                }
                catch (NodeException ex) {
                    if (Advisory.addMessageIfLinked("Failed to create a Variable" + variableName + " in Node " + node.toStringExtra() + ": " + ex.getMessage())) continue;
                    throw ex;
                }
            }
        }
        if (withTables) {
            JSONObject jsonTable = jsonConfiguration.optJSONObject(NodeConfiguration.Table.table.toString());
            node.setTable(jsonTable);
        }
        if (jsonNode.has(Meta.Field.meta.toString())) {
            node.jsonMeta = jsonNode.optJSONObject(Meta.Field.meta.toString());
        }
        if (jsonNode.has(Graphics.Field.graphics.toString())) {
            node.jsonGraphics = jsonNode.optJSONObject(Graphics.Field.graphics.toString());
        }
        try {
            node.loadMetaNotes();
        }
        catch (JSONException ex) {
            throw new NodeException("Failed loading model notes", ex);
        }
        try {
            boolean visible = jsonNode.optJSONObject(NodeGraphics.Field.graphics.toString()).optBoolean(NodeGraphics.Field.visible.toString());
            node.getLogicNode().setVisible(visible);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return node;
    }

    private void loadMetaNotes() throws JSONException {
        if (this.jsonMeta == null || this.jsonMeta.optJSONArray(Meta.Field.notes.toString()) == null) {
            return;
        }
        JSONArray jsonNotes = this.jsonMeta.optJSONArray(Meta.Field.notes.toString());
        for (int i = 0; i < jsonNotes.length(); ++i) {
            JSONObject jsonNote = jsonNotes.getJSONObject(i);
            String name = jsonNote.getString(Meta.Field.name.toString());
            String text = jsonNote.getString(Meta.Field.text.toString());
            this.getLogicNode().getNotes().addNote(name, text);
        }
        this.jsonMeta.remove(Meta.Field.notes.toString());
    }

    public void setTableColumns(double[][] columns) throws NodeException {
        for (int i = 0; i < columns.length; ++i) {
            for (int j = 0; j < columns[i].length; ++j) {
                if (columns[i].length == columns[0].length) continue;
                throw new NodeException("Table is not a square matrix");
            }
        }
        int sizeGiven = columns.length * columns[0].length;
        List<ExtendedNode> parentNodes = this.getParentExtendedNodes();
        AtomicInteger sizeExpected = new AtomicInteger(1);
        parentNodes.stream().forEachOrdered(n -> sizeExpected.set(sizeExpected.get() * n.getExtendedStates().size()));
        sizeExpected.set(sizeExpected.get() * this.getLogicNode().getExtendedStates().size());
        if (sizeExpected.get() != sizeGiven) {
            throw new NodeException("Table has a wrong number of cells (expecting: " + sizeExpected + ", given: " + sizeGiven + ")");
        }
        try {
            this.getLogicNode().setNPT(columns, parentNodes);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new NodeException("Failed to set table, check parents", ex);
        }
        catch (ExtendedBNException ex) {
            throw new NodeException("Failed to set table", ex);
        }
    }

    public void setTableRows(double[][] rows) throws NodeException {
        double[][] columns = NodeConfiguration.transposeMatrix(rows);
        this.setTableColumns(columns);
    }

    public final boolean setTableUniform() {
        try {
            double[][] nptNew;
            float[][] nptCurrent = this.getLogicNode().getNPT();
            for (double[] row : nptNew = new double[nptCurrent[0].length][nptCurrent.length]) {
                Arrays.fill(row, 1.0);
            }
            MathsHelper.normaliseMatrix((double[][])nptNew);
            this.getLogicNode().setNPT(nptNew, this.getParentExtendedNodes());
        }
        catch (Exception ex) {
            Logger.printThrowableIfDebug((Throwable)ex);
            return false;
        }
        return true;
    }

    public void resetTable() throws NodeException {
        try {
            this.getNetwork().getLogicNetwork().getConnBN().getNodeWithAltId(this.getId()).updateNPTSize();
        }
        catch (Exception ex) {
            throw new NodeException("Failed to reset table for node " + this.toStringExtra(), ex);
        }
    }

    public void setTable(JSONObject jsonTable) throws NodeException {
        block20: {
            if (jsonTable == null || jsonTable.length() == 0) {
                return;
            }
            List<String> allowedTokens = this.getAllowedFunctionTokens();
            try {
                String tableType = jsonTable.getString(NodeConfiguration.Table.type.toString());
                if (jsonTable.has(NodeConfiguration.Table.probabilities.toString())) {
                    try {
                        double[][] npt = NodeConfiguration.extractNPTColumns(jsonTable.getJSONArray(NodeConfiguration.Table.probabilities.toString()));
                        if (NodeConfiguration.Table.column.toString().equals(jsonTable.optString(NodeConfiguration.Table.pvalues.toString()))) {
                            npt = NodeConfiguration.transposeMatrix(npt);
                        }
                        List parentNodes = this.getParents().stream().filter(n -> n.getNetwork().equals(this.getNetwork())).map(node -> node.getLogicNode()).collect(Collectors.toList());
                        this.getLogicNode().setNPT(npt, parentNodes);
                    }
                    catch (ExtendedBNException ex) {
                        this.getLogicNode().setNptReCalcRequired(true);
                        this.resetTable();
                        if (!tableType.equalsIgnoreCase(NodeConfiguration.TableType.Manual.toString())) {
                            Advisory.addMessageIfLinked("Node " + this.toStringExtra() + " underlying table was corrupted and will need to be recalculated");
                        }
                        if (ex.getCause() instanceof ArrayIndexOutOfBoundsException) {
                            throw new NodeException("NPT size is wrong", ex);
                        }
                        throw new NodeException("Failed to extract NPT", ex);
                    }
                    catch (ArrayIndexOutOfBoundsException ex) {
                        this.getLogicNode().setNptReCalcRequired(true);
                        this.resetTable();
                        throw new NodeException("NPT size is wrong", ex);
                    }
                }
                if (tableType.equalsIgnoreCase(NodeConfiguration.TableType.Manual.toString())) {
                    if (this.isSimulated() && !Advisory.addMessageIfLinked("Node " + this.toStringExtra() + " is simulated, but the table data had a Manual table type. We recommend to check the expressions in this node.")) {
                        throw new NodeException("Can't set a manual NPT for a simulated node");
                    }
                    break block20;
                }
                if (tableType.equalsIgnoreCase(NodeConfiguration.TableType.Expression.toString())) {
                    String expression = jsonTable.getJSONArray(NodeConfiguration.Table.expressions.toString()).getString(0);
                    try {
                        this.setTableFunction(expression, allowedTokens);
                        break block20;
                    }
                    catch (NodeException ex) {
                        if (Advisory.getCurrentThreadGroup() != null) {
                            Advisory.getCurrentThreadGroup().addMessage(new Advisory.AdvisoryMessage("Failed parsing functions for node " + this.toStringExtra()));
                            break block20;
                        }
                        throw ex;
                    }
                }
                if (tableType.equalsIgnoreCase(NodeConfiguration.TableType.Partitioned.toString())) {
                    try {
                        List<String> partitionParentIDs = JSONUtils.toList(jsonTable.getJSONArray(NodeConfiguration.Table.partitions.toString()), String.class);
                        List<Node> partitionParents = partitionParentIDs.stream().map(id -> this.getNetwork().getNode((String)id)).collect(Collectors.toList());
                        List<String> expressions = JSONUtils.toList(jsonTable.getJSONArray(NodeConfiguration.Table.expressions.toString()), String.class);
                        this.setTableFunctions(expressions, allowedTokens, false, partitionParents);
                        break block20;
                    }
                    catch (JSONException ex) {
                        if (Advisory.getCurrentThreadGroup() != null) {
                            Advisory.getCurrentThreadGroup().addMessage(new Advisory.AdvisoryMessage("Partitioned table definition missing or corrupt in node " + this.toStringExtra(), ex));
                            break block20;
                        }
                        throw ex;
                    }
                }
                throw new NodeException("Invalid table type");
            }
            catch (JSONException ex) {
                throw new NodeException(JSONUtils.createMissingAttrMessage(ex), ex);
            }
        }
    }

    public void setTableFunction(String expression) throws NodeException {
        this.setTableFunctions(Arrays.asList(expression), this.getAllowedFunctionTokens(), false, null);
    }

    public List<String> getAllowedFunctionTokens() {
        ArrayList<String> allowedTokens = new ArrayList<String>();
        List parentIDs = this.getParents().stream().filter(n -> n.getNetwork().equals(this.getNetwork())).map(node -> node.getId()).collect(Collectors.toList());
        List variableNames = this.getLogicNode().getExpressionVariables().getAllVariableNames();
        allowedTokens.addAll(parentIDs);
        allowedTokens.addAll(variableNames);
        return allowedTokens;
    }

    public void setTableFunction(String expression, List<String> allowedTokens) throws NodeException {
        this.setTableFunctions(Arrays.asList(expression), allowedTokens, false, null);
    }

    protected void setTableFunction(String expression, List<String> allowedTokens, boolean relaxFunctionRequirements) throws NodeException {
        this.setTableFunctions(Arrays.asList(expression), allowedTokens, relaxFunctionRequirements, null);
    }

    protected ExtendedNodeFunction parseAsFunction(String expression, List<String> allowedTokens, boolean relaxFunctionRequirements) {
        if (Advisory.getCurrentThreadGroup() != null && expression.contains("?")) {
            expression = expression.replace("?", "");
            Advisory.getCurrentThreadGroup().addMessage(new Advisory.AdvisoryMessage("Functions for node " + this.toStringExtra() + " contained invalid characters and were cleaned. We recommend to check the expressions in this node."));
        }
        try {
            ExtendedNodeFunction enf = ExpressionParser.parseFunctionFromString((String)expression, allowedTokens, (boolean)relaxFunctionRequirements);
            for (String fname : ExpressionParser.parsed_functions) {
                if (!fname.replaceAll(" ", "").equalsIgnoreCase(enf.getName())) continue;
                enf.setName(fname);
            }
            return enf;
        }
        catch (ParseException ex) {
            try {
                if (Advisory.getCurrentThreadGroup() != null) {
                    Advisory.getCurrentThreadGroup().addMessage(new Advisory.AdvisoryMessage("Functions for node " + this.toStringExtra() + " contain invalid tokens. We recommend to check the expressions in this node.", ex));
                    ExtendedNodeFunction enf = ExpressionParser.parseFunctionFromString((String)expression, null, (boolean)true);
                    for (String fname : ExpressionParser.parsed_functions) {
                        if (!fname.replaceAll(" ", "").equalsIgnoreCase(enf.getName())) continue;
                        enf.setName(fname);
                    }
                    return enf;
                }
                throw ex;
            }
            catch (ParseException ex2) {
                throw new NodeException("Unable to parse node function `" + expression + "`", ex2);
            }
        }
    }

    public void setTableFunctions(List<String> expressions, List<Node> partitionParents) throws NodeException {
        this.setTableFunctions(expressions, this.getAllowedFunctionTokens(), false, partitionParents);
    }

    protected void setTableFunctions(List<String> expressions, List<String> allowedTokens, boolean relaxFunctionRequirements, List<Node> partitionParents) throws NodeException {
        if (expressions.isEmpty()) {
            return;
        }
        List functions = expressions.stream().map(expression -> this.parseAsFunction((String)expression, allowedTokens, relaxFunctionRequirements)).collect(Collectors.toList());
        if (functions.size() == 1) {
            this.getLogicNode().setExpression((ExtendedNodeFunction)functions.get(0));
            return;
        }
        if (functions.size() > 1) {
            if (partitionParents != null && !partitionParents.isEmpty()) {
                this.partitionByParents(partitionParents);
            }
            this.getLogicNode().setPartitionedExpressions(functions);
        }
    }

    public void partitionByParents(List<Node> partitionParents) throws NodeException {
        this.getLogicNode().setPartitionedExpressionModelNodes(partitionParents.stream().map(node -> node.getLogicNode()).collect(Collectors.toList()));
    }

    public void setStates(String[] states) throws NodeException {
        this.setStates(Arrays.asList(states));
    }

    public void setStates(List<String> states) throws NodeException {
        if (this.isSimulated()) {
            throw new NodeException("Can't set states for a simulated node");
        }
        ExtendedNode en = this.getLogicNode();
        uk.co.agena.minerva.util.model.DataSet ds = new uk.co.agena.minerva.util.model.DataSet();
        for (int s = 0; s < states.size(); ++s) {
            String stateName = states.get(s).trim();
            if (stateName.isEmpty()) {
                throw new NodeException("State name can't be an empty string");
            }
            if (en instanceof RankedEN) {
                ds.addLabelledDataPoint(stateName);
                continue;
            }
            if (en instanceof NumericalEN) {
                Range range;
                double lowerBound = Double.NEGATIVE_INFINITY;
                double upperBound = Double.POSITIVE_INFINITY;
                if (stateName.contains(" - ")) {
                    String[] parts = stateName.split(" - ");
                    lowerBound = Double.parseDouble(parts[0]);
                    upperBound = Double.parseDouble(parts[1]);
                } else {
                    upperBound = lowerBound = Double.parseDouble(stateName);
                }
                try {
                    range = new Range(lowerBound, upperBound);
                }
                catch (MinervaRangeException ex) {
                    throw new NodeException("Invalid state range in `" + stateName + "`", ex);
                }
                NameDescription nd = new NameDescription(stateName, stateName);
                IntervalDataPoint dp = new IntervalDataPoint();
                dp.setLabel(nd.getShortDescription());
                dp.setValue(range.midPoint());
                dp.setIntervalLowerBound(range.getLowerBound());
                dp.setIntervalUpperBound(range.getUpperBound());
                ds.addDataPoint((DataPoint)dp);
                continue;
            }
            ds.addLabelledDataPoint(stateName);
        }
        try {
            en.createExtendedStates(ds);
        }
        catch (ExtendedStateException | ExtendedStateNumberingException ex) {
            throw new NodeException("Failed to parse states", ex);
        }
    }

    public void setStates(JSONArray jsonStates) throws NodeException {
        if (jsonStates == null || jsonStates.length() == 0) {
            return;
        }
        String[] states = new String[jsonStates.length()];
        for (int s = 0; s < jsonStates.length(); ++s) {
            states[s] = jsonStates.optString(s, "");
        }
        this.setStates(states);
    }

    public boolean convertToSimulated() throws NodeException {
        boolean canSimulate;
        boolean bl = canSimulate = this.getLogicNode() instanceof ContinuousEN && !(this.getLogicNode() instanceof RankedEN);
        if (!canSimulate || this.isSimulated()) {
            return false;
        }
        NodeConfiguration.setDefaultIntervalStates(this);
        ContinuousEN cien = (ContinuousEN)this.getLogicNode();
        cien.setSimulationNode(true);
        if (cien.getExpression() == null) {
            this.setTableFunction("Arithmetic(0)");
        }
        return true;
    }

    public boolean convertToStatic(DataSet dataSet) throws NodeException {
        boolean canSimulate;
        boolean bl = canSimulate = this.getLogicNode() instanceof ContinuousEN && !(this.getLogicNode() instanceof RankedEN);
        if (!canSimulate || !this.isSimulated()) {
            return false;
        }
        ContinuousEN cien = (ContinuousEN)this.getLogicNode();
        int dsIndex = dataSet.getDataSetIndex();
        MarginalDataItemList mdil = this.getNetwork().getModel().getLogicModel().getMarginalDataStore().getMarginalDataItemListForNode(this.getNetwork().getLogicNetwork(), this.getLogicNode());
        if (mdil.getMarginalDataItems().isEmpty()) {
            throw new NodeException("Model missing calculation results");
        }
        if (mdil.getMarginalDataItems().size() < dsIndex + 1) {
            throw new NodeException("Model missing calculation results for the Data Set " + dataSet.getId());
        }
        JSONObject jObservation = null;
        if (dataSet.hasObservation(this)) {
            jObservation = dataSet.getObservation(this).toJson();
        }
        try {
            uk.co.agena.minerva.util.model.DataSet ds = this.getNetwork().getModel().getLogicModel().getMarginalDataStore().getMarginalDataItemListForNode(this.getNetwork().getLogicNetwork(), this.getLogicNode()).getMarginalDataItemAtIndex(dsIndex).getDataset();
            ContinuousEN.ConvertToNonSimulation((ContinuousEN)cien, (uk.co.agena.minerva.util.model.DataSet)ds, (ExtendedBN)this.getNetwork().getLogicNetwork(), (Scenario)dataSet.getLogicScenario());
            for (VariableObservation vo : dataSet.getVariableObservations(this)) {
                String voName = vo.getVariableName();
                double varVal = vo.getVariableValue();
                VariableList logicVarList = this.getLogicNode().getExpressionVariables();
                uk.co.agena.minerva.util.model.Variable logicVar = logicVarList.getVariable(voName);
                logicVarList.updateVariable(logicVar, voName, varVal);
            }
        }
        catch (IndexOutOfBoundsException | NullPointerException | ExtendedStateException | ExtendedStateNumberingException | MinervaVariableException ex) {
            throw new NodeException("Failed to retrieve calculation result from Data Set", ex);
        }
        if (jObservation != null) {
            dataSet.setObservation(jObservation);
        }
        return true;
    }

    public boolean isSimulated() {
        if (this.getLogicNode() instanceof ContinuousEN && !(this.getLogicNode() instanceof RankedEN)) {
            return ((ContinuousEN)this.getLogicNode()).isSimulationNode();
        }
        return false;
    }

    public boolean isNumericInterval() {
        return Type.ContinuousInterval.equals((Object)this.getType()) || Type.IntegerInterval.equals((Object)this.getType());
    }

    public String toString() {
        return this.toJson().toString();
    }

    public String toStringExtra() {
        return "`" + this.getNetwork().getName() + " (" + this.getNetwork().getId() + ")`.`" + this.getName() + " (" + this.getId() + ")`";
    }

    public Network getNetwork() {
        return this.network;
    }

    public ExtendedNode getLogicNode() {
        return this.logicNode;
    }

    @Override
    public String getId() {
        return this.getLogicNode().getConnNodeId();
    }

    @Override
    public void setId(String newId) throws NodeException {
        String oldId = this.getId();
        String errorMessage = "Failed to change ID of Node from `" + oldId + "` to `" + newId + "`";
        try {
            this.getNetwork().changeContainedId(this, newId);
            this.getNetwork().getLogicNetwork().updateConnNodeId(this.getLogicNode(), newId);
        }
        catch (CoreBNNodeNotFoundException | ExtendedBNException ex) {
            try {
                this.getNetwork().changeContainedId(this, oldId);
            }
            catch (NetworkException ex2) {
                throw new NodeException(errorMessage, ex2);
            }
            throw new NodeException(errorMessage, ex);
        }
        catch (NetworkException ex) {
            throw new NodeException(errorMessage, ex);
        }
    }

    @Override
    public void setName(String name) {
        this.getLogicNode().getName().setShortDescription(name);
    }

    @Override
    public String getName() {
        return this.getLogicNode().getName().getShortDescription();
    }

    @Override
    public void setDescription(String description) {
        this.getLogicNode().getName().setLongDescription(description);
    }

    @Override
    public String getDescription() {
        return this.getLogicNode().getName().getLongDescription();
    }

    @Override
    public int compareTo(Node o) {
        return new Id(this.getId()).compareTo(new Id(o.getId()));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Node)) {
            return false;
        }
        return this.getLogicNode() == ((Node)obj).getLogicNode();
    }

    public int hashCode() {
        return System.identityHashCode(this.getLogicNode());
    }

    @Override
    public boolean unlink(Node linkedNode) {
        return Node.unlinkNodes(this, linkedNode);
    }

    @Override
    public JSONObject toJson() {
        JSONObject json = JSONAdapter.toJSONObject(this.logicNode);
        json.put(Graphics.Field.graphics.toString(), (Object)this.jsonGraphics);
        json.put(Meta.Field.meta.toString(), (Object)this.jsonMeta);
        return json;
    }

    public State getState(String label) {
        return State.getState(this, label);
    }

    public List<State> getStates() {
        return this.getLogicNode().getExtendedStates().stream().map(es -> State.getState(this, es.getName().getShortDescription())).collect(Collectors.toList());
    }

    public Type getType() {
        ExtendedNode en = this.getLogicNode();
        return NodeConfiguration.resolveNodeType(en);
    }

    protected void setLogicNode(ExtendedNode logicNode) {
        if (!new Id(this.getId()).equals(new Id(logicNode.getConnNodeId()))) {
            throw new AgenaRiskRuntimeException("Logic node id mismatch: " + this.getId() + "," + logicNode.getConnNodeId());
        }
        this.logicNode = logicNode;
    }

    private List<ExtendedNode> getParentExtendedNodes() {
        return this.getParents().stream().map(node -> node.getLogicNode()).collect(Collectors.toList());
    }

    private void createDefaultStates() {
        switch (this.getType()) {
            case ContinuousInterval: 
            case IntegerInterval: {
                this.setStates(new String[]{"-Infinity - -1", "-1 - 1", "1 - Infinity"});
                this.setTableRows(new double[][]{{1.0}, {1.0}, {1.0}});
            }
        }
    }

    public NodeConfiguration.TableType getTableType() {
        switch (this.logicNode.getFunctionMode()) {
            default: {
                return NodeConfiguration.TableType.Manual;
            }
            case 1: {
                return NodeConfiguration.TableType.Expression;
            }
            case 2: 
        }
        return NodeConfiguration.TableType.Partitioned;
    }

    public boolean isConnectedInput() {
        return this.getLinksIn().stream().anyMatch(link -> !Objects.equals(this.getNetwork(), link.getFromNode().getNetwork()));
    }

    public boolean isConnectedOutput() {
        return this.getLinksOut().stream().anyMatch(link -> !Objects.equals(this.getNetwork(), link.getToNode().getNetwork()));
    }

    public Set<Node> getAncestors() {
        LinkedHashSet<Node> set = new LinkedHashSet<Node>();
        this.getParents().stream().filter(n -> Objects.equals(this.getNetwork(), n.getNetwork())).forEach(n -> {
            set.add((Node)n);
            set.addAll(n.getAncestors());
        });
        return set;
    }

    public Set<Node> getDescendants() {
        LinkedHashSet<Node> set = new LinkedHashSet<Node>();
        this.getChildren().stream().filter(n -> Objects.equals(this.getNetwork(), n.getNetwork())).forEach(n -> {
            set.add((Node)n);
            set.addAll(n.getDescendants());
        });
        return set;
    }

    public synchronized Variable createVariable(String varName, double defaultValue) throws NetworkException {
        try {
            uk.co.agena.minerva.util.model.Variable logicVariable = this.getLogicNode().addExpressionVariable(varName, defaultValue, true);
            Variable variable = new Variable(this, logicVariable);
            this.variablesCache.put(varName, variable);
            return variable;
        }
        catch (ExtendedBNException ex) {
            throw new NodeException(ex.getMessage(), ex);
        }
    }

    public synchronized Variable getVariable(String varName) {
        if (this.variablesCache.containsKey(varName)) {
            return this.variablesCache.get(varName);
        }
        try {
            VariableList logicVarList = this.getLogicNode().getExpressionVariables();
            uk.co.agena.minerva.util.model.Variable logicVar = logicVarList.getVariable(varName);
            Variable variable = new Variable(this, logicVar);
            this.variablesCache.put(varName, variable);
            return variable;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public synchronized void removeVariable(String varName) {
        try {
            VariableList logicVarList = this.getLogicNode().getExpressionVariables();
            uk.co.agena.minerva.util.model.Variable logicVar = logicVarList.getVariable(varName);
            logicVarList.removeVariable(logicVar);
            this.variablesCache.remove(varName);
        }
        catch (Exception ex) {
            return;
        }
    }

    public synchronized List<Variable> getVariables() {
        VariableList logicVarList = this.getLogicNode().getExpressionVariables();
        List list = logicVarList.getAllVariableNames().stream().map(varName -> this.getVariable((String)varName)).collect(Collectors.toList());
        return Collections.unmodifiableList(list);
    }

    public static enum Field {
        nodes,
        node,
        id,
        name,
        description;

    }

    public static enum Type {
        Boolean,
        Labelled,
        Ranked,
        DiscreteReal,
        ContinuousInterval,
        IntegerInterval;

    }
}

